/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.utils.MinecraftTimeFormatter;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.annotation.PostConstruct;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class PlaceholderExpansionHook
extends PlaceholderExpansion {
    private final MultiverseCore plugin;
    private final WorldManager worldManager;
    private final MVEconomist economist;

    @Inject
    public PlaceholderExpansionHook(MultiverseCore plugin, WorldManager worldManager, MVEconomist economist) {
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.economist = economist;
    }

    @PostConstruct
    public boolean register() {
        return super.register();
    }

    @NotNull
    public String getIdentifier() {
        return "multiverse-core";
    }

    @NotNull
    public String getAuthor() {
        return StringFormatter.joinAnd(this.plugin.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
        ArrayList paramsArray = Lists.newArrayList((Object[])REPatterns.UNDERSCORE.split(params));
        if (paramsArray.isEmpty()) {
            this.warning("No placeholder key defined");
            return null;
        }
        String placeholder = (String)paramsArray.removeFirst();
        String worldName = this.parseWorldName(offlinePlayer, paramsArray);
        if (worldName == null) {
            return null;
        }
        return (String)this.worldManager.getLoadedWorld(worldName).onEmpty(() -> this.warning("Multiverse World not found: " + worldName)).map(world -> this.getWorldPlaceHolderValue(placeholder, paramsArray, (LoadedMultiverseWorld)world)).getOrNull();
    }

    @Nullable
    private String parseWorldName(OfflinePlayer offlinePlayer, List<String> paramsArray) {
        if (paramsArray.isEmpty()) {
            if (offlinePlayer instanceof Player) {
                Player player = (Player)offlinePlayer;
                return player.getWorld().getName();
            }
            this.warning("You must specify a world name for non-player placeholders");
            return null;
        }
        String paramWorldName = paramsArray.getLast();
        if (this.worldManager.isLoadedWorld(paramWorldName)) {
            paramsArray.removeLast();
            return paramWorldName;
        }
        if (offlinePlayer instanceof Player) {
            Player player = (Player)offlinePlayer;
            return player.getWorld().getName();
        }
        this.warning("Multiverse World not found: " + paramWorldName);
        return null;
    }

    @Nullable
    private String getWorldPlaceHolderValue(@NotNull String placeholder, @NotNull List<String> placeholderParams, @NotNull LoadedMultiverseWorld world) {
        switch (placeholder.toLowerCase(Locale.ENGLISH)) {
            case "alias": {
                return world.getAliasOrName();
            }
            case "animalspawn": {
                return String.valueOf(world.getEntitySpawnConfig().getSpawnCategoryConfig(SpawnCategory.ANIMAL).isSpawn());
            }
            case "autoheal": {
                return String.valueOf(world.getAutoHeal());
            }
            case "blacklist": {
                return String.join((CharSequence)", ", world.getWorldBlacklist());
            }
            case "currency": {
                return String.valueOf(world.getCurrency());
            }
            case "difficulty": {
                return world.getDifficulty().toString();
            }
            case "entryfee": {
                return this.economist.formatPrice(world.getPrice(), world.getCurrency());
            }
            case "environment": {
                return world.getEnvironment().toString().toLowerCase();
            }
            case "flight": {
                return String.valueOf(world.isAllowFlight());
            }
            case "gamemode": {
                return world.getGameMode().toString().toLowerCase();
            }
            case "generator": {
                return world.getGenerator();
            }
            case "hunger": {
                return String.valueOf(world.isHunger());
            }
            case "monstersspawn": {
                return String.valueOf(world.getEntitySpawnConfig().getSpawnCategoryConfig(SpawnCategory.MONSTER).isSpawn());
            }
            case "name": {
                return world.getName();
            }
            case "playerlimit": {
                return String.valueOf(world.getPlayerLimit());
            }
            case "price": {
                return String.valueOf(world.getPrice());
            }
            case "pvp": {
                return String.valueOf(world.getPvp());
            }
            case "seed": {
                return String.valueOf(world.getSeed());
            }
            case "time": {
                String timeFormat = !placeholderParams.isEmpty() ? placeholderParams.getFirst() : "";
                long time = world.getBukkitWorld().map(World::getTime).getOrElse(0L);
                switch (timeFormat) {
                    case "": {
                        return String.valueOf(time);
                    }
                    case "12h": {
                        return MinecraftTimeFormatter.format12h(time);
                    }
                    case "24h": {
                        return MinecraftTimeFormatter.format24h(time);
                    }
                }
                return MinecraftTimeFormatter.formatTime(time, timeFormat);
            }
            case "type": {
                return world.getBukkitWorld().map(World::getWorldType).map(Enum::name).getOrElse("null");
            }
            case "weather": {
                return String.valueOf(world.isAllowWeather());
            }
        }
        this.warning("Unknown placeholder: " + placeholder);
        return null;
    }
}

