/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.UnsafeFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.permissions.CorePermissionsChecker;
import org.mvplugins.multiverse.core.teleportation.AsyncSafetyTeleporter;
import org.mvplugins.multiverse.core.teleportation.TeleportFailureReason;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class SpawnCommand
extends CoreCommand {
    private final WorldManager worldManager;
    private final AsyncSafetyTeleporter safetyTeleporter;
    private final CorePermissionsChecker permissionsChecker;
    private final UnsafeFlags flags;

    @Inject
    SpawnCommand(@NotNull WorldManager worldManager, @NotNull AsyncSafetyTeleporter safetyTeleporter, @NotNull CorePermissionsChecker permissionsChecker, @NotNull UnsafeFlags flags) {
        this.worldManager = worldManager;
        this.safetyTeleporter = safetyTeleporter;
        this.permissionsChecker = permissionsChecker;
        this.flags = flags;
    }

    @CommandAlias(value="mvspawn")
    @Subcommand(value="spawn")
    @CommandPermission(value="@mvspawn")
    @CommandCompletion(value="@playersarray:checkPermissions=@mvspawnother|@flags:resolveUntil=arg1,groupName=unsafe @flags:groupName=unsafe")
    @Syntax(value="[player]")
    @Description(value="{@@mv-core.spawn.description}")
    void onSpawnTpCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerAware") @Syntax(value="[player]") @Description(value="{@@mv-core.spawn.player.description}") Player[] players, @Optional @Syntax(value="[--unsafe]") @Description(value="") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        Map<World, List<Entity>> playersByWorld = Arrays.stream(players).collect(Collectors.groupingBy(Entity::getWorld));
        playersByWorld.forEach((world, entities) -> this.teleportPlayersToSpawn(issuer, (World)world, (List<Entity>)entities, !parsedFlags.hasFlag(this.flags.unsafe)));
    }

    private void teleportPlayersToSpawn(MVCommandIssuer issuer, World world, List<Entity> entities, boolean checkSafety) {
        LoadedMultiverseWorld mvWorld = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(world).getOrNull();
        if (mvWorld == null) {
            issuer.sendMessage("The world '" + world.getName() + "' is not a multiverse world!");
            return;
        }
        if (!this.permissionsChecker.checkSpawnPermission(issuer.getIssuer(), entities, (MultiverseWorld)mvWorld)) {
            issuer.sendMessage("You do not have permission to use this command in this world!");
            return;
        }
        if (entities.size() == 1) {
            this.handleSingleTeleport(issuer, mvWorld, entities.get(0), checkSafety);
        } else {
            this.handleMultiTeleport(issuer, mvWorld, entities, checkSafety);
        }
    }

    private void handleSingleTeleport(MVCommandIssuer issuer, LoadedMultiverseWorld mvWorld, Entity entity, boolean checkSafety) {
        this.safetyTeleporter.to(mvWorld.getSpawnLocation()).by(issuer).checkSafety(checkSafety).teleportSingle(entity).onSuccess(() -> issuer.sendInfo((MessageKeyProvider)MVCorei18n.SPAWN_SUCCESS, MessageReplacement.Replace.PLAYER.with(entity.equals((Object)issuer.getPlayer()) ? Message.of((MessageKeyProvider)MVCorei18n.GENERIC_YOU, new MessageReplacement[0]) : Message.of(entity.getName(), new MessageReplacement[0])), MessageReplacement.Replace.WORLD.with(mvWorld.getName()))).onFailure(failure -> issuer.sendError((MessageKeyProvider)MVCorei18n.SPAWN_FAILED, MessageReplacement.Replace.PLAYER.with(entity.equals((Object)issuer.getPlayer()) ? Message.of((MessageKeyProvider)MVCorei18n.GENERIC_YOU, new MessageReplacement[0]) : Message.of(entity.getName(), new MessageReplacement[0])), MessageReplacement.Replace.WORLD.with(mvWorld.getName()), MessageReplacement.Replace.REASON.with(((Attempt)failure.getFirst()).getFailureMessage())));
    }

    private void handleMultiTeleport(MVCommandIssuer issuer, LoadedMultiverseWorld mvWorld, List<Entity> entities, boolean checkSafety) {
        this.safetyTeleporter.to(mvWorld.getSpawnLocation()).by(issuer).checkSafety(checkSafety).teleport(entities).onSuccessCount(successCount -> issuer.sendMessage(MVCorei18n.SPAWN_SUCCESS, MessageReplacement.Replace.PLAYER.with(successCount + " players"), MessageReplacement.Replace.WORLD.with(mvWorld.getName()))).onFailureCount(reasonsCountMap -> {
            for (Map.Entry entry : reasonsCountMap.entrySet()) {
                CoreLogging.finer("Failed to teleport %s players to %s: %s", entry.getValue(), mvWorld.getName(), entry.getKey());
                issuer.sendError((MessageKeyProvider)MVCorei18n.SPAWN_FAILED, MessageReplacement.Replace.PLAYER.with(String.valueOf(entry.getValue()) + " players"), MessageReplacement.Replace.WORLD.with(mvWorld.getName()), MessageReplacement.Replace.REASON.with(((TeleportFailureReason)entry.getKey()).getMessageKey()));
            }
        });
    }
}

