/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.entity.EntityPurger;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class PurgeEntitiesCommand
extends CoreCommand {
    private final EntityPurger entityPurger;

    @Inject
    PurgeEntitiesCommand(EntityPurger entityPurger) {
        this.entityPurger = entityPurger;
    }

    @Subcommand(value="purge-entities")
    @CommandPermission(value="multiverse.core.purge")
    @CommandCompletion(value="@mvworlds:scope=loaded")
    @Syntax(value="[world]")
    void onPurgeEntityCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerAware") @Syntax(value="[world]") LoadedMultiverseWorld world) {
        int purgeCount = this.entityPurger.purgeEntities(world);
        issuer.sendMessage("Successfully purged " + purgeCount + " entities in world " + world.getName() + ".");
    }
}

