/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.helpers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.World;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;

@Service
public final class DimensionFinder {
    private final CoreConfig config;
    private final WorldManager worldManager;

    @Inject
    DimensionFinder(@NotNull CoreConfig config, @NotNull WorldManager worldManager) {
        this.config = config;
        this.worldManager = worldManager;
    }

    public boolean isOverworld(MultiverseWorld world) {
        return world.getEnvironment() == World.Environment.NORMAL;
    }

    public boolean isNether(MultiverseWorld world) {
        return world.getEnvironment() == World.Environment.NETHER;
    }

    public boolean isEnd(MultiverseWorld world) {
        return world.getEnvironment() == World.Environment.THE_END;
    }

    public Option<MultiverseWorld> getOverworldWorld(MultiverseWorld world) {
        if (this.isOverworld(world)) {
            return Option.of(world);
        }
        if (this.isNether(world)) {
            return this.getOverworldNameFromNether(world.getName()).flatMap(this.worldManager::getWorld);
        }
        if (this.isEnd(world)) {
            return this.getOverworldNameFromEnd(world.getName()).flatMap(this.worldManager::getWorld);
        }
        return Option.none();
    }

    public Option<MultiverseWorld> getNetherWorld(MultiverseWorld world) {
        if (this.isOverworld(world)) {
            return this.worldManager.getWorld(this.getNetherNameFromOverworld(world.getName()));
        }
        if (this.isNether(world)) {
            return Option.of(world);
        }
        if (this.isEnd(world)) {
            return this.getOverworldNameFromEnd(world.getName()).map(this::getNetherNameFromOverworld).flatMap(this.worldManager::getWorld);
        }
        return Option.none();
    }

    public Option<MultiverseWorld> getEndWorld(MultiverseWorld world) {
        if (this.isOverworld(world)) {
            return this.worldManager.getWorld(this.getEndNameFromOverworld(world.getName()));
        }
        if (this.isNether(world)) {
            return this.getOverworldNameFromNether(world.getName()).map(this::getEndNameFromOverworld).flatMap(this.worldManager::getWorld);
        }
        if (this.isEnd(world)) {
            return Option.of(world);
        }
        return Option.none();
    }

    private Option<String> getOverworldNameFromNether(String worldName) {
        return this.config.getNetherWorldNameFormat().getOverworldFromName(worldName);
    }

    private Option<String> getOverworldNameFromEnd(String worldName) {
        return this.config.getEndWorldNameFormat().getOverworldFromName(worldName);
    }

    @NotNull
    private String getNetherNameFromOverworld(String worldName) {
        return this.config.getNetherWorldNameFormat().replaceOverworld(worldName);
    }

    @NotNull
    private String getEndNameFromOverworld(String worldName) {
        return this.config.getEndWorldNameFormat().replaceOverworld(worldName);
    }

    public static final class DimensionFormat {
        public static final String OVERWORLD_PLACEHOLDER = "%overworld%";
        private final String format;
        private final Pattern pattern;

        public DimensionFormat(@NotNull String format) {
            this.format = format;
            if (!format.contains(OVERWORLD_PLACEHOLDER)) {
                throw new IllegalArgumentException("Dimension format must contain overworld placeholder: %overworld%");
            }
            this.pattern = Pattern.compile("^" + format.replace(OVERWORLD_PLACEHOLDER, "(?<worldname>.+)") + "$");
        }

        public Option<String> getOverworldFromName(String worldName) {
            Matcher matcher = this.pattern.matcher(worldName);
            if (!matcher.matches()) {
                CoreLogging.finer("%s does not match %s", worldName, this.format);
                return Option.none();
            }
            return Option.of(matcher.group("worldname"));
        }

        public String replaceOverworld(String worldName) {
            return this.format.replace(OVERWORLD_PLACEHOLDER, worldName);
        }

        @NotNull
        public String getFormat() {
            return this.format;
        }

        public String toString() {
            return this.format;
        }
    }
}

