/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.config.node.ConfigHeaderNode;
import org.mvplugins.multiverse.core.config.node.ConfigNode;
import org.mvplugins.multiverse.core.config.node.ListConfigNode;
import org.mvplugins.multiverse.core.config.node.NodeGroup;
import org.mvplugins.multiverse.core.config.node.serializer.NodeSerializer;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.event.world.MVWorldPropertyChangedEvent;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.MaterialConverter;
import org.mvplugins.multiverse.core.world.AllowedPortalType;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.entity.EntitySpawnConfig;
import org.mvplugins.multiverse.core.world.helpers.EnforcementHandler;
import org.mvplugins.multiverse.core.world.location.NullSpawnLocation;
import org.mvplugins.multiverse.core.world.location.SpawnLocation;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Option;

final class WorldConfigNodes {
    private static final double CONFIG_VERSION = 1.0;
    private final NodeGroup nodes = new NodeGroup();
    private WorldManager worldManager;
    private EnforcementHandler enforcementHandler;
    private CoreConfig config;
    private MultiverseWorld world = null;
    final ConfigNode<Boolean> adjustSpawn = this.node(ConfigNode.builder("adjust-spawn", Boolean.class).defaultValue(false));
    final ConfigNode<String> alias = this.node((ConfigNode.Builder)ConfigNode.builder("alias", String.class).defaultValue("").onSetValue((oldValue, newValue) -> {
        if (this.world == null) {
            return;
        }
        this.world.updateColourlessAlias();
    }));
    final ConfigNode<Boolean> allowAdvancementGrant = this.node(ConfigNode.builder("allow-advancement-grant", Boolean.class).defaultValue(true));
    final ConfigNode<Boolean> allowFlight = this.node((ConfigNode.Builder)ConfigNode.builder("allow-flight", Boolean.class).defaultValue(false).onSetValue((oldValue, newValue) -> {
        MultiverseWorld patt0$temp = this.world;
        if (!(patt0$temp instanceof LoadedMultiverseWorld)) {
            return;
        }
        LoadedMultiverseWorld loadedWorld = (LoadedMultiverseWorld)patt0$temp;
        this.enforcementHandler.handleAllFlightEnforcement(loadedWorld);
    }));
    final ConfigNode<Boolean> allowWeather = this.node((ConfigNode.Builder)ConfigNode.builder("allow-weather", Boolean.class).defaultValue(true).onSetValue((oldValue, newValue) -> {
        MultiverseWorld patt0$temp = this.world;
        if (!(patt0$temp instanceof LoadedMultiverseWorld)) {
            return;
        }
        LoadedMultiverseWorld loadedWorld = (LoadedMultiverseWorld)patt0$temp;
        loadedWorld.getBukkitWorld().peek(world -> {
            if (!world.isClearWeather() && !newValue.booleanValue()) {
                world.setThundering(false);
                world.setStorm(false);
            }
        });
    }));
    final ConfigNode<Boolean> anchorRespawn = this.node(ConfigNode.builder("anchor-respawn", Boolean.class).defaultValue(true));
    final ConfigNode<Boolean> autoHeal = this.node(ConfigNode.builder("auto-heal", Boolean.class).defaultValue(true));
    final ConfigNode<Boolean> autoLoad = this.node(ConfigNode.builder("auto-load", Boolean.class).defaultValue(true));
    final ConfigNode<Boolean> bedRespawn = this.node(ConfigNode.builder("bed-respawn", Boolean.class).defaultValue(true));
    final ConfigNode<String> biome = this.node((ConfigNode.Builder)ConfigNode.builder("biome", String.class).defaultValue("@error").hidden());
    final ConfigNode<Difficulty> difficulty = this.node((ConfigNode.Builder)ConfigNode.builder("difficulty", Difficulty.class).defaultValue(Difficulty.NORMAL).onSetValue((oldValue, newValue) -> {
        MultiverseWorld patt0$temp = this.world;
        if (!(patt0$temp instanceof LoadedMultiverseWorld)) {
            return;
        }
        LoadedMultiverseWorld loadedWorld = (LoadedMultiverseWorld)patt0$temp;
        loadedWorld.getBukkitWorld().peek(bukkitWorld -> bukkitWorld.setDifficulty(newValue));
    }));
    final ConfigNode<Boolean> entryFeeEnabled = this.node((ConfigNode.Builder)ConfigNode.builder("entry-fee.enabled", Boolean.class).defaultValue(false).name("entryfee-enabled"));
    final ConfigNode<Double> entryFeeAmount = this.node((ConfigNode.Builder)ConfigNode.builder("entry-fee.amount", Double.class).defaultValue(0.0).name("entryfee-amount"));
    final ConfigNode<Material> entryFeeCurrency = this.node((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder("entry-fee.currency", Material.class).defaultValue(MVEconomist.VAULT_ECONOMY_MATERIAL).name("entryfee-currency")).serializer(new NodeSerializer<Material>(){

        @Override
        public Material deserialize(Object object, Class<Material> type) {
            return Option.of(object).map(String::valueOf).map(materialStr -> {
                if (materialStr.equalsIgnoreCase("@vault-economy")) {
                    return MVEconomist.VAULT_ECONOMY_MATERIAL;
                }
                return MaterialConverter.stringToMaterial(materialStr);
            }).getOrElse(MVEconomist.VAULT_ECONOMY_MATERIAL);
        }

        @Override
        public Object serialize(Material object, Class<Material> type) {
            return Option.of(object).map(material -> material == MVEconomist.VAULT_ECONOMY_MATERIAL ? "@vault-economy" : material.name()).getOrElse("@vault-economy");
        }
    }));
    final ConfigNode<World.Environment> environment = this.node((ConfigNode.Builder)ConfigNode.builder("environment", World.Environment.class).defaultValue(World.Environment.NORMAL).hidden());
    final ConfigNode<GameMode> gamemode = this.node((ConfigNode.Builder)ConfigNode.builder("gamemode", GameMode.class).defaultValue(GameMode.SURVIVAL).onSetValue((oldValue, newValue) -> {
        MultiverseWorld patt0$temp = this.world;
        if (!(patt0$temp instanceof LoadedMultiverseWorld)) {
            return;
        }
        LoadedMultiverseWorld loadedWorld = (LoadedMultiverseWorld)patt0$temp;
        this.enforcementHandler.handleAllGameModeEnforcement(loadedWorld);
    }));
    final ConfigNode<String> generator = this.node((ConfigNode.Builder)ConfigNode.builder("generator", String.class).defaultValue("@error").hidden());
    final ConfigNode<Boolean> hidden = this.node(ConfigNode.builder("hidden", Boolean.class).defaultValue(false));
    final ConfigNode<Boolean> hunger = this.node(ConfigNode.builder("hunger", Boolean.class).defaultValue(true));
    final ConfigNode<Boolean> keepSpawnInMemory = this.node((ConfigNode.Builder)ConfigNode.builder("keep-spawn-in-memory", Boolean.class).defaultValue(true).onSetValue((oldValue, newValue) -> {
        MultiverseWorld patt0$temp = this.world;
        if (!(patt0$temp instanceof LoadedMultiverseWorld)) {
            return;
        }
        LoadedMultiverseWorld loadedWorld = (LoadedMultiverseWorld)patt0$temp;
        loadedWorld.getBukkitWorld().peek(bukkitWorld -> bukkitWorld.setKeepSpawnInMemory(newValue.booleanValue()));
    }));
    final ConfigNode<Integer> playerLimit = this.node(ConfigNode.builder("player-limit", Integer.class).defaultValue(-1));
    final ConfigNode<AllowedPortalType> portalForm = this.node(ConfigNode.builder("portal-form", AllowedPortalType.class).defaultValue(AllowedPortalType.ALL));
    final ConfigNode<Boolean> pvp = this.node((ConfigNode.Builder)ConfigNode.builder("pvp", Boolean.class).defaultValue(true).onSetValue((oldValue, newValue) -> {
        MultiverseWorld patt0$temp = this.world;
        if (!(patt0$temp instanceof LoadedMultiverseWorld)) {
            return;
        }
        LoadedMultiverseWorld loadedWorld = (LoadedMultiverseWorld)patt0$temp;
        loadedWorld.getBukkitWorld().peek(bukkitWorld -> bukkitWorld.setPVP(newValue.booleanValue()));
    }));
    final ConfigNode<String> respawnWorld = this.node((ConfigNode.Builder)ConfigNode.builder("respawn-world", String.class).defaultValue("").suggester(input -> {
        if (this.worldManager == null) {
            return Collections.emptyList();
        }
        return this.worldManager.getWorlds().stream().map(MultiverseWorld::getName).toList();
    }));
    final ConfigNode<Double> scale = this.node(ConfigNode.builder("scale", Double.class).defaultValue(() -> {
        if (this.world == null) {
            return 1.0;
        }
        return switch (this.world.getEnvironment()) {
            case World.Environment.NETHER -> 8.0;
            case World.Environment.THE_END -> 16.0;
            default -> 1.0;
        };
    }));
    final ConfigNode<Long> seed = this.node((ConfigNode.Builder)ConfigNode.builder("seed", Long.class).defaultValue(Long.MIN_VALUE).hidden());
    final ConfigNode<SpawnLocation> spawnLocation = this.node((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder("spawn-location", SpawnLocation.class).defaultValue(NullSpawnLocation.get()).hidden()).onSetValue((oldValue, newValue) -> {
        MultiverseWorld patt0$temp = this.world;
        if (!(patt0$temp instanceof LoadedMultiverseWorld)) {
            return;
        }
        LoadedMultiverseWorld loadedWorld = (LoadedMultiverseWorld)patt0$temp;
        if (newValue == null || newValue instanceof NullSpawnLocation) {
            return;
        }
        loadedWorld.getBukkitWorld().peek(bukkitWorld -> {
            bukkitWorld.setSpawnLocation((Location)newValue);
            newValue.setWorld((World)bukkitWorld);
        });
    }));
    final ConfigNode<EntitySpawnConfig> enititySpawnConfig = this.node((ConfigNode.Builder)((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder("spawning", EntitySpawnConfig.class).defaultValue(() -> EntitySpawnConfig.fromSection(this.config, (ConfigurationSection)new MemoryConfiguration())).hidden()).serializer(new NodeSerializer<EntitySpawnConfig>(){

        @Override
        public EntitySpawnConfig deserialize(Object object, Class<EntitySpawnConfig> type) {
            MemoryConfiguration memoryConfiguration;
            if (object instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)object;
                memoryConfiguration = section;
            } else {
                memoryConfiguration = new MemoryConfiguration();
            }
            MemoryConfiguration spawnSection = memoryConfiguration;
            return EntitySpawnConfig.fromSection(WorldConfigNodes.this.config, (ConfigurationSection)spawnSection);
        }

        @Override
        public Object serialize(EntitySpawnConfig object, Class<EntitySpawnConfig> type) {
            return object.toSection();
        }
    })).onSetValue((oldValue, newValue) -> {
        newValue.setWorldRef(this.world);
        newValue.applyConfigToWorld();
    }));
    final ConfigNode<List<String>> worldBlacklist = this.node(ListConfigNode.listBuilder("world-blacklist", String.class));
    final ConfigNode<Double> version = this.node((ConfigNode.Builder)ConfigNode.builder("version", Double.class).defaultValue(1.0).hidden());

    WorldConfigNodes(@NotNull MultiverseCore multiverseCore) {
        this.worldManager = multiverseCore.getServiceLocator().getService(WorldManager.class, new Annotation[0]);
        this.enforcementHandler = multiverseCore.getServiceLocator().getService(EnforcementHandler.class, new Annotation[0]);
        this.config = multiverseCore.getServiceLocator().getService(CoreConfig.class, new Annotation[0]);
    }

    MultiverseWorld getWorld() {
        return this.world;
    }

    void setWorld(MultiverseWorld world) {
        this.world = world;
    }

    NodeGroup getNodes() {
        return this.nodes;
    }

    private <T> ConfigNode<T> node(ConfigNode.Builder<T, ?> nodeBuilder) {
        nodeBuilder.onSetValue((oldValue, newValue) -> {
            if (Objects.equals(oldValue, newValue)) {
                return;
            }
            if (this.world == null) {
                return;
            }
            MVWorldPropertyChangedEvent<Object> mvWorldPropertyChangeEvent = new MVWorldPropertyChangedEvent<Object>(this.world, Option.of(nodeBuilder.name()).getOrElse(nodeBuilder.path()), oldValue, newValue);
            Bukkit.getPluginManager().callEvent(mvWorldPropertyChangeEvent);
            CoreLogging.finer("MVWorldPropertyChangeEvent fired for world '%s' with name '%s' and value '%s'", this.world.getName(), nodeBuilder.path(), newValue);
        });
        ConfigHeaderNode node = nodeBuilder.build();
        this.nodes.add(node);
        return node;
    }
}

