/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.matcher;

import java.util.regex.Pattern;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.matcher.StringMatcher;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Try;

@ApiStatus.AvailableSince(value="5.2")
public class WildcardStringMatcher
implements StringMatcher {
    private final String wildcard;
    private final Pattern pattern;

    @ApiStatus.AvailableSince(value="5.2")
    public WildcardStringMatcher(@NotNull String wildcard) {
        this.wildcard = wildcard;
        this.pattern = (Pattern)Try.of(() -> Pattern.compile(("\\Q" + wildcard + "\\E").replace("*", "\\E.*\\Q"))).onFailure(ex -> CoreLogging.warning("Failed to compile wildcard '%s': %s", wildcard, ex.getMessage())).getOrNull();
    }

    @Override
    public boolean matches(@Nullable String value) {
        if (this.pattern == null || value == null) {
            return false;
        }
        return this.pattern.matcher(value).matches();
    }
}

