/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.permissions;

import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.mvplugins.multiverse.core.utils.CoreLogging;

public final class PermissionUtils {
    private static boolean debugPermissions = false;

    private PermissionUtils() {
    }

    public static boolean isDebugPermissions() {
        return debugPermissions;
    }

    public static void setDebugPermissions(boolean debugPermissions) {
        PermissionUtils.debugPermissions = debugPermissions;
    }

    public static String concatPermission(String permission, String ... child) {
        return permission + "." + String.join((CharSequence)".", child);
    }

    public static boolean hasPermission(CommandSender sender, String permission) {
        if (sender.hasPermission(permission)) {
            if (debugPermissions && !(sender instanceof ConsoleCommandSender)) {
                CoreLogging.finer("Checking sender [%s] has permission [%s] : YES", sender.getName(), permission);
            }
            return true;
        }
        if (debugPermissions && !(sender instanceof ConsoleCommandSender)) {
            CoreLogging.finer("Checking sender [%s] has permission [%s] : NO", sender.getName(), permission);
        }
        return false;
    }
}

