/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.display;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.display.handlers.DefaultSendHandler;
import org.mvplugins.multiverse.core.display.handlers.SendHandler;
import org.mvplugins.multiverse.core.display.parsers.ContentProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

public class ContentDisplay {
    private final List<ContentProvider> contentParsers = new ArrayList<ContentProvider>();
    private SendHandler sendHandler = DefaultSendHandler.getInstance();

    @NotNull
    public static ContentDisplay create() {
        return new ContentDisplay();
    }

    ContentDisplay() {
    }

    @NotNull
    public ContentDisplay addContent(@NotNull ContentProvider parser) {
        this.contentParsers.add(parser);
        return this;
    }

    @NotNull
    public ContentDisplay withSendHandler(@NotNull SendHandler handler) {
        this.sendHandler = handler;
        return this;
    }

    public void send(@NotNull MVCommandIssuer issuer) {
        Objects.requireNonNull(this.sendHandler, "No send handler set for content display");
        ArrayList<String> parsedContent = new ArrayList<String>();
        this.contentParsers.forEach(parser -> parsedContent.addAll(parser.parse(issuer)));
        this.sendHandler.send(issuer, parsedContent);
    }
}

