/*
 * Decompiled with CFR 0.152.
 */
package be.mrtibo.ridecounters.data;

import be.mrtibo.ridecounters.Ridecounters;
import be.mrtibo.ridecounters.data.DBType;
import be.mrtibo.ridecounters.data.Database;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\b\u0010\t\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lbe/mrtibo/ridecounters/data/DatabaseUpgrader;", "", "<init>", "()V", "hasLegacyFormat", "", "copySqliteDB", "", "attemptUpgrade", "finishUpgrade", "TC-Ridecounters"})
public final class DatabaseUpgrader {
    @NotNull
    public static final DatabaseUpgrader INSTANCE = new DatabaseUpgrader();

    private DatabaseUpgrader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean hasLegacyFormat() {
        AutoCloseable autoCloseable = Database.INSTANCE.connection$TC_Ridecounters();
        Throwable throwable = null;
        try {
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            PreparedStatement stmt = conn.prepareStatement(switch (WhenMappings.$EnumSwitchMapping$0[Database.INSTANCE.getType().ordinal()]) {
                case 1 -> "SELECT name FROM sqlite_schema WHERE \ntype ='table' AND\nname LIKE 'ridecounter_data';";
                case 2 -> "SHOW TABLES LIKE 'ridecounter_data';";
                default -> throw new NoWhenBranchMatchedException();
            });
            boolean bl2 = stmt.executeQuery().next();
            return bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    public final void copySqliteDB() {
        Path oldPluginPath = Ridecounters.Companion.getINSTANCE().getDataPath().getParent().resolve("Ridecounters");
        File oldConfigFile = oldPluginPath.resolve("config.yml").toFile();
        if (!oldConfigFile.exists()) {
            return;
        }
        String string = YamlConfiguration.loadConfiguration((File)oldConfigFile).getString("database.file");
        if (string == null) {
            string = "ridecounters.db";
        }
        String oldSqliteName = string;
        Path sqliteFile = oldPluginPath.resolve(oldSqliteName);
        Intrinsics.checkNotNull(sqliteFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(sqliteFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        Ridecounters.Companion.getINSTANCE().getLogger().info("Copying legacy format sqlite database...");
        Path path = sqliteFile;
        Path path2 = Ridecounters.Companion.getINSTANCE().getDataPath();
        String string2 = Ridecounters.Companion.getINSTANCE().getConfig().getString("database.path");
        if (string2 == null) {
            string2 = "ridecounter_data.db";
        }
        Path path3 = path2.resolve(string2);
        Intrinsics.checkNotNullExpressionValue(path3, "resolve(...)");
        Path path4 = path3;
        CopyOption[] copyOptionArray = new CopyOption[]{};
        Intrinsics.checkNotNullExpressionValue(Files.copy(path, path4, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), "copy(...)");
        path = sqliteFile;
        Path path5 = oldPluginPath.resolve(oldSqliteName + ".old");
        Intrinsics.checkNotNullExpressionValue(path5, "resolve(...)");
        path4 = path5;
        copyOptionArray = new CopyOption[]{};
        Intrinsics.checkNotNullExpressionValue(Files.move(path, path4, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), "move(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void attemptUpgrade() {
        if (!this.hasLegacyFormat()) {
            return;
        }
        Ridecounters.Companion.getINSTANCE().getLogger().info("Found legacy ridecounter data, attempting to upgrade...");
        AutoCloseable autoCloseable = Database.INSTANCE.connection$TC_Ridecounters();
        Throwable throwable = null;
        try {
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            Statement stmt = conn.createStatement();
            stmt.addBatch("INSERT INTO players(uuid, username)\nSELECT uuid, lastName FROM ridecounter_players;");
            stmt.addBatch("INSERT INTO rides(id, name, altname)\nSELECT id, name, shortName FROM ridecounter_rides;");
            stmt.addBatch("INSERT INTO ridecount_total(ride_id, player_uuid, total)\nSELECT d.ride, p.uuid, d.val FROM ridecounter_data d\nINNER JOIN ridecounter_players p ON d.player = p.id;");
            int[] nArray = stmt.executeBatch();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        this.finishUpgrade();
        Ridecounters.Companion.getINSTANCE().getLogger().info("Finished upgrading legacy data.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finishUpgrade() {
        Ridecounters.Companion.getINSTANCE().getLogger().info("Renaming legacy tables...");
        AutoCloseable autoCloseable = Database.INSTANCE.connection$TC_Ridecounters();
        Throwable throwable = null;
        try {
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            Statement statement = conn.createStatement();
            statement.addBatch("ALTER TABLE ridecounter_players RENAME TO ridecounter_players_old;");
            statement.addBatch("ALTER TABLE ridecounter_rides RENAME TO ridecounter_rides_old;");
            statement.addBatch("ALTER TABLE ridecounter_data RENAME TO ridecounter_data_old;");
            int[] nArray = statement.executeBatch();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DBType.values().length];
            try {
                nArray[DBType.SQLITE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DBType.MARIADB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

