/*
 * Decompiled with CFR 0.152.
 */
package be.mrtibo.lib.cloud.annotations.extractor;

import be.mrtibo.lib.cloud.annotations.AnnotationParser;
import be.mrtibo.lib.cloud.annotations.Command;
import be.mrtibo.lib.cloud.annotations.descriptor.CommandDescriptor;
import be.mrtibo.lib.cloud.annotations.descriptor.ImmutableCommandDescriptor;
import be.mrtibo.lib.cloud.annotations.extractor.CommandExtractor;
import be.mrtibo.lib.cloud.util.annotation.AnnotationAccessor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL, consumers={"be.mrtibo.lib.cloud.annotations.*"})
public final class CommandExtractorImpl
implements CommandExtractor {
    private final AnnotationParser<?> annotationParser;

    public CommandExtractorImpl(@NonNull AnnotationParser<?> annotationParser) {
        this.annotationParser = annotationParser;
    }

    @Override
    public @NonNull Collection<@NonNull CommandDescriptor> extractCommands(@NonNull Object instance) {
        AnnotationAccessor classAnnotations = AnnotationAccessor.of(instance.getClass());
        Command classCommand = classAnnotations.annotation(Command.class);
        String syntaxPrefix = classCommand == null ? "" : this.annotationParser.processString(classCommand.value()) + " ";
        Method[] methods2 = instance.getClass().getDeclaredMethods();
        ArrayList<CommandDescriptor> commandDescriptors = new ArrayList<CommandDescriptor>();
        for (Method method : methods2) {
            Command[] commands = (Command[])method.getAnnotationsByType(Command.class);
            if (commands.length == 0) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException(String.format("@Command annotated method '%s' is static! @Command annotated methods should not be static.", method.getName()));
            }
            for (Command command2 : commands) {
                String syntax = syntaxPrefix + this.annotationParser.processString(command2.value());
                commandDescriptors.add(ImmutableCommandDescriptor.builder().method(method).syntax(this.annotationParser.syntaxParser().parseSyntax(method, syntax)).commandToken(syntax.split(" ")[0].split("\\|")[0]).requiredSender(command2.requiredSender()).build());
            }
        }
        return commandDescriptors;
    }
}

