/*
 * Decompiled with CFR 0.152.
 */
package be.mrtibo.ridecounters.update;

import be.mrtibo.ridecounters.Ridecounters;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lbe/mrtibo/ridecounters/update/UpdateChecker;", "", "<init>", "()V", "API_URL", "", "notify", "", "old", "new", "checkForUpdate", "Ridecounters"})
public final class UpdateChecker {
    @NotNull
    public static final UpdateChecker INSTANCE = new UpdateChecker();
    @NotNull
    private static final String API_URL = "https://hangar.papermc.io/api/v1/projects/tc-ridecounters/latestrelease";

    private UpdateChecker() {
    }

    public final void notify(@NotNull String old, @NotNull String string) {
        Intrinsics.checkNotNullParameter(old, "old");
        Intrinsics.checkNotNullParameter(string, "new");
        Ridecounters.Companion.getINSTANCE().getLogger().info("A new version of TC-Ridecounters is available! You are using version " + old + ", latest is " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkForUpdate() {
        String string = Ridecounters.Companion.getINSTANCE().getPluginMeta().getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        String currentVersion = string;
        HttpClient httpClient = HttpClient.newHttpClient();
        try {
            HttpClient $this$checkForUpdate_u24lambda_u240 = httpClient;
            boolean bl = false;
            AutoCloseable autoCloseable = $this$checkForUpdate_u24lambda_u240;
            Throwable throwable = null;
            try {
                HttpClient client = (HttpClient)autoCloseable;
                boolean bl2 = false;
                String version = client.send(HttpRequest.newBuilder(URI.create(API_URL)).GET().header("accept", "text/plain").build(), HttpResponse.BodyHandlers.ofString()).body();
                if (!Intrinsics.areEqual(version, currentVersion)) {
                    Intrinsics.checkNotNull(version);
                    if (!StringsKt.isBlank(version)) {
                        INSTANCE.notify(currentVersion, version);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
            Object object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
    }
}

