/*
 * Decompiled with CFR 0.152.
 */
package be.mrtibo.lib.cloud.bean;

import be.mrtibo.lib.cloud.Command;
import be.mrtibo.lib.cloud.CommandFactory;
import be.mrtibo.lib.cloud.CommandManager;
import be.mrtibo.lib.cloud.bean.CommandProperties;
import be.mrtibo.lib.cloud.context.CommandContext;
import be.mrtibo.lib.cloud.execution.CommandExecutionHandler;
import be.mrtibo.lib.cloud.meta.CommandMeta;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public abstract class CommandBean<C>
implements CommandExecutionHandler<C>,
CommandFactory<C> {
    protected CommandBean() {
    }

    @Override
    public @NonNull List<@NonNull Command<? extends C>> createCommands(@NonNull CommandManager<C> commandManager) {
        Command.Builder builder = commandManager.commandBuilder(this.properties().name(), this.properties().aliases(), this.meta()).handler(this);
        return Collections.singletonList(this.configure(builder).build());
    }

    protected @NonNull CommandMeta meta() {
        return CommandMeta.builder().build();
    }

    protected abstract @NonNull CommandProperties properties();

    protected abstract @NonNull Command.Builder<? extends C> configure(@NonNull Command.Builder<C> var1);

    @Override
    public void execute(@NonNull CommandContext<C> commandContext) {
    }
}

