/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mariadb.jdbc.export.HaMode;
import org.mariadb.jdbc.export.SslMode;

public class HostAddress {
    public final String host;
    public final int port;
    public final String pipe;
    public final SslMode sslMode;
    public final String localSocket;
    public Boolean primary;
    private Long threadsConnected;
    private Long threadConnectedTimeout;

    private HostAddress(String host, int port, Boolean primary, String pipe, String localSocket, SslMode sslMode) {
        this.host = host;
        this.port = port;
        this.primary = primary;
        this.pipe = pipe;
        this.localSocket = localSocket;
        this.sslMode = sslMode;
    }

    public static HostAddress from(String host, int port) {
        return new HostAddress(host, port, null, null, null, null);
    }

    public static HostAddress pipe(String pipe) {
        return new HostAddress(null, 3306, null, pipe, null, null);
    }

    public static HostAddress localSocket(String localSocket) {
        return new HostAddress(null, 3306, null, null, localSocket, null);
    }

    public static HostAddress from(String host, int port, boolean primary) {
        return new HostAddress(host, port, primary, null, null, null);
    }

    public static HostAddress from(String host, int port, String sslMode) {
        return new HostAddress(host, port, null, null, null, sslMode == null ? null : SslMode.from(sslMode));
    }

    public static HostAddress from(String host, int port, boolean primary, String sslMode) {
        return new HostAddress(host, port, primary, null, null, sslMode == null ? null : SslMode.from(sslMode));
    }

    public static List<HostAddress> parse(String spec, HaMode haMode) throws SQLException {
        if ("".equals(spec)) {
            return new ArrayList<HostAddress>(0);
        }
        String[] tokens = spec.trim().split(",");
        int size = tokens.length;
        ArrayList<HostAddress> arr = new ArrayList<HostAddress>(size);
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.startsWith("address=")) {
                arr.add(HostAddress.parseParameterHostAddress(token, haMode, i == 0));
                continue;
            }
            arr.add(HostAddress.parseSimpleHostAddress(token, haMode, i == 0));
        }
        return arr;
    }

    private static HostAddress parseSimpleHostAddress(String str, HaMode haMode, boolean first2) throws SQLException {
        String host;
        int port = 3306;
        if (str.charAt(0) == '[') {
            int ind = str.indexOf(93);
            host = str.substring(1, ind);
            if (ind != str.length() - 1 && str.charAt(ind + 1) == ':') {
                port = HostAddress.getPort(str.substring(ind + 2));
            }
        } else if (str.contains(":")) {
            String[] hostPort = str.split(":");
            host = hostPort[0];
            port = HostAddress.getPort(hostPort[1]);
        } else {
            host = str;
        }
        boolean primary = haMode != HaMode.REPLICATION || first2;
        return new HostAddress(host, port, primary, null, null, null);
    }

    private static int getPort(String portString) throws SQLException {
        try {
            return Integer.parseInt(portString);
        }
        catch (NumberFormatException nfe) {
            throw new SQLException("Incorrect port value : " + portString);
        }
    }

    private static HostAddress parseParameterHostAddress(String str, HaMode haMode, boolean first2) throws SQLException {
        String host = null;
        int port = 3306;
        String sslMode = null;
        String pipe = null;
        String localsocket = null;
        Boolean primary = null;
        String[] array = str.replace(" ", "").split("(?=\\()|(?<=\\))");
        block16: for (int i = 1; i < array.length; ++i) {
            String[] token = array[i].replace("(", "").replace(")", "").trim().split("=");
            if (token.length != 2) {
                throw new IllegalArgumentException("Invalid connection URL, expected key=value pairs, found " + array[i]);
            }
            String key = token[0].toLowerCase();
            String value = token[1].toLowerCase();
            switch (key) {
                case "host": {
                    host = value.replace("[", "").replace("]", "");
                    continue block16;
                }
                case "localsocket": {
                    localsocket = token[1];
                    continue block16;
                }
                case "pipe": {
                    pipe = token[1];
                    continue block16;
                }
                case "port": {
                    port = HostAddress.getPort(value);
                    continue block16;
                }
                case "sslmode": {
                    sslMode = token[1];
                    continue block16;
                }
                case "type": {
                    if ("master".equalsIgnoreCase(value) || "primary".equalsIgnoreCase(value)) {
                        primary = true;
                        continue block16;
                    }
                    if ("slave".equalsIgnoreCase(value) || "replica".equalsIgnoreCase(value)) {
                        primary = false;
                        continue block16;
                    }
                    throw new SQLException(String.format("Wrong type value %s (possible value primary/replica)", array[i]));
                }
            }
        }
        if (primary == null) {
            primary = haMode != HaMode.REPLICATION || first2;
        }
        return new HostAddress(host, port, primary, pipe, localsocket, sslMode == null ? null : SslMode.from(sslMode));
    }

    public String toString() {
        if (this.pipe != null) {
            return String.format("address=(pipe=%s)", this.pipe);
        }
        if (this.localSocket != null) {
            return String.format("address=(localSocket=%s)", this.localSocket);
        }
        if (this.sslMode == null && this.primary != Boolean.FALSE) {
            return this.port != 3306 ? this.host + ":" + this.port : this.host;
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = this.host;
        objectArray[1] = this.port != 3306 ? "(port=" + this.port + ")" : "";
        Object object = objectArray[2] = this.sslMode != null ? "(sslMode=" + this.sslMode.getValue() + ")" : "";
        objectArray[3] = this.primary != null ? "(type=" + (this.primary != false ? "primary)" : "replica)") : "";
        return String.format("address=(host=%s)%s%s%s", objectArray);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAddress that = (HostAddress)o;
        return this.port == that.port && Objects.equals(this.host, that.host) && Objects.equals(this.primary, that.primary);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.primary);
    }

    public Long getThreadsConnected() {
        return this.threadsConnected;
    }

    public void setThreadsConnected(long threadsConnected) {
        this.threadsConnected = threadsConnected;
        this.threadConnectedTimeout = System.currentTimeMillis() + 180000L;
    }

    public void forceThreadsConnected(long threadsConnected, long threadConnectedTimeout) {
        this.threadsConnected = threadsConnected;
        this.threadConnectedTimeout = threadConnectedTimeout;
    }

    public HostAddress withPipe(String pipe) {
        return new HostAddress(this.host, this.port, this.primary, pipe, this.localSocket, this.sslMode);
    }

    public HostAddress withLocalSocket(String localSocket) {
        return new HostAddress(this.host, this.port, this.primary, this.pipe, localSocket, this.sslMode);
    }

    public HostAddress withPort(int port) {
        return new HostAddress(this.host, port, this.primary, this.pipe, this.localSocket, this.sslMode);
    }

    public Long getThreadConnectedTimeout() {
        return this.threadConnectedTimeout;
    }
}

