/*
 * Decompiled with CFR 0.152.
 */
package be.mrtibo.ridecounters.data;

import be.mrtibo.lib.kotlinx.coroutines.BuildersKt;
import be.mrtibo.lib.kotlinx.coroutines.CoroutineScope;
import be.mrtibo.ridecounters.Ridecounters;
import be.mrtibo.ridecounters.data.Connector;
import be.mrtibo.ridecounters.data.DBType;
import be.mrtibo.ridecounters.data.Database;
import be.mrtibo.ridecounters.data.MariaDBConnector;
import be.mrtibo.ridecounters.data.SQLiteConnector;
import be.mrtibo.ridecounters.data.records.PlayerRecord;
import be.mrtibo.ridecounters.data.records.RideRecord;
import be.mrtibo.ridecounters.data.records.RidecountTopRecord;
import be.mrtibo.ridecounters.data.records.RidecountTotalRecord;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0018J(\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0015J \u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0015J \u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'H\u0086@\u00a2\u0006\u0002\u0010(J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0018J$\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010.J\u0018\u0010/\u001a\u0004\u0018\u00010+2\u0006\u0010\u001c\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0018J\u001e\u00100\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0015J\u001e\u00101\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0015J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u000205H\u0002J\u0012\u00106\u001a\u0004\u0018\u00010+2\u0006\u00104\u001a\u000205H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u00067"}, d2={"Lbe/mrtibo/ridecounters/data/Database;", "", "<init>", "()V", "connector", "Lbe/mrtibo/ridecounters/data/Connector;", "type", "Lbe/mrtibo/ridecounters/data/DBType;", "getType", "()Lbe/mrtibo/ridecounters/data/DBType;", "setupConnection", "", "shutdown", "createTables", "connection", "Ljava/sql/Connection;", "createRide", "", "id", "", "name", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteRide", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setCounter", "Lbe/mrtibo/ridecounters/data/records/RidecountTotalRecord;", "uuid", "rideId", "value", "(Ljava/lang/String;Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "incrementCounter", "getTotalRidecount", "getTopTotalRidecounter", "Lbe/mrtibo/ridecounters/data/records/RidecountTopRecord;", "limit", "(Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "savePlayer", "player", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRides", "", "Lbe/mrtibo/ridecounters/data/records/RideRecord;", "idMatching", "offset", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRide", "changeName", "changeAltName", "mapPlayer", "Lbe/mrtibo/ridecounters/data/records/PlayerRecord;", "resultSet", "Ljava/sql/ResultSet;", "mapRide", "Ridecounters"})
@SourceDebugExtension(value={"SMAP\nDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Database.kt\nbe/mrtibo/ridecounters/data/Database\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,314:1\n1915#2,2:315\n1915#2,2:317\n1#3:319\n*S KotlinDebug\n*F\n+ 1 Database.kt\nbe/mrtibo/ridecounters/data/Database\n*L\n48#1:315,2\n59#1:317,2\n*E\n"})
public final class Database {
    @NotNull
    public static final Database INSTANCE = new Database();
    private static Connector connector;

    private Database() {
    }

    @NotNull
    public final DBType getType() {
        Connector connector = Database.connector;
        if (connector == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connector");
            connector = null;
        }
        return connector.getType();
    }

    /*
     * Unable to fully structure code
     */
    public final void setupConnection() {
        type = Ridecounters.Companion.getINSTANCE().getConfig().getString("database.type", "sqlite");
        v0 = type;
        if (v0 == null) ** GOTO lbl-1000
        v1 = v0.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(v1, "toLowerCase(...)");
        v0 = v1;
        if (v1 != null) {
            v2 = StringsKt.trim((CharSequence)v0).toString();
        } else lbl-1000:
        // 2 sources

        {
            v2 = var2_2 = null;
        }
        if (Intrinsics.areEqual(var2_2, "mariadb")) {
            v3 = new MariaDBConnector();
        } else if (Intrinsics.areEqual(var2_2, "sqlite")) {
            v3 = new SQLiteConnector();
        } else {
            throw new IllegalArgumentException("Unsupported database type '" + type + "'");
        }
        if ((v4 = (Database.connector = v3)) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connector");
            v4 = null;
        }
        v4.open();
    }

    public final void shutdown() {
        try {
            Connector connector = Database.connector;
            Connector connector2 = connector;
            if (connector2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("connector");
                connector2 = null;
            }
            connector2.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void createTables() {
        Connector connector = Database.connector;
        if (connector == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connector");
            connector = null;
        }
        String schemaPathName = "/schema/" + connector.getType().getTypeName() + ".sql";
        Closeable closeable = this.getClass().getResourceAsStream(schemaPathName);
        Throwable throwable = null;
        try {
            Object object;
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            if (inputStream == null) {
                Ridecounters.Companion.getINSTANCE().getLogger().severe("No schema found at " + schemaPathName);
                return;
            }
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            AutoCloseable autoCloseable = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            List<String> full = TextStreamsKt.readLines(autoCloseable instanceof BufferedReader ? (BufferedReader)autoCloseable : new BufferedReader((Reader)autoCloseable, n));
            List statements = new ArrayList();
            StringBuilder sb = new StringBuilder();
            Iterable $this$forEach$iv = full;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl2 = false;
                if (!(!StringsKt.isBlank(line))) continue;
                sb.append(line);
                if (!StringsKt.endsWith$default(line, ");", false, 2, null)) continue;
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                statements.add(string);
                StringsKt.clear(sb);
            }
            autoCloseable = INSTANCE.connection();
            Throwable throwable2 = null;
            try {
                void $this$forEach$iv2;
                Connection connection = (Connection)autoCloseable;
                boolean bl3 = false;
                Statement stmt = connection.createStatement();
                Iterable bl2 = statements;
                Intrinsics.checkNotNull(stmt);
                Statement statement = stmt;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    String p0 = (String)element$iv;
                    boolean bl4 = false;
                    statement.addBatch(p0);
                }
                object = stmt.executeBatch();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable2);
            }
            Object object2 = object;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private final Connection connection() {
        Connector connector = Database.connector;
        if (connector == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connector");
            connector = null;
        }
        return connector.getConnection();
    }

    @Nullable
    public final Object createRide(@NotNull String id, @NotNull String name, @NotNull Continuation<? super Integer> $completion) {
        return BuildersKt.withContext(Ridecounters.Companion.getAsyncDispatcher(), (Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(id, name, null){
            int label;
            final /* synthetic */ String $id;
            final /* synthetic */ String $name;
            {
                this.$id = $id;
                this.$name = $name;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Integer n;
                        ResultKt.throwOnFailure($result);
                        AutoCloseable autoCloseable = Database.access$connection(Database.INSTANCE);
                        String string = this.$id;
                        String string2 = this.$name;
                        Throwable throwable = null;
                        try {
                            Connection it = (Connection)autoCloseable;
                            boolean bl = false;
                            PreparedStatement stmt = it.prepareStatement("INSERT INTO rides (id, name) VALUES (?, ?)");
                            stmt.setString(1, string);
                            stmt.setString(2, string2);
                            n = Boxing.boxInt(stmt.executeUpdate());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                        return n;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object deleteRide(@NotNull String id, @NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext(Ridecounters.Companion.getAsyncDispatcher(), (Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(id, null){
            int label;
            final /* synthetic */ String $id;
            {
                this.$id = $id;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        AutoCloseable autoCloseable = Database.access$connection(Database.INSTANCE);
                        String string = this.$id;
                        Throwable throwable = null;
                        try {
                            Connection it = (Connection)autoCloseable;
                            boolean bl = false;
                            PreparedStatement stmt = it.prepareStatement("DELETE FROM rides WHERE id = ?");
                            stmt.setString(1, string);
                            int num = stmt.executeUpdate();
                            Boolean bl2 = Boxing.boxBoolean(num > 0);
                            return bl2;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object setCounter(@NotNull String uuid, @NotNull String rideId, int value, @NotNull Continuation<? super RidecountTotalRecord> $completion) {
        return BuildersKt.withContext(Ridecounters.Companion.getAsyncDispatcher(), (Function2)new Function2<CoroutineScope, Continuation<? super RidecountTotalRecord>, Object>(uuid, rideId, value, null){
            int label;
            final /* synthetic */ String $uuid;
            final /* synthetic */ String $rideId;
            final /* synthetic */ int $value;
            {
                this.$uuid = $uuid;
                this.$rideId = $rideId;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        AutoCloseable autoCloseable = Database.access$connection(Database.INSTANCE);
                        String string = this.$rideId;
                        String string2 = this.$uuid;
                        int n = this.$value;
                        Throwable throwable = null;
                        try {
                            Connection it = (Connection)autoCloseable;
                            boolean bl = false;
                            Connector connector = Database.access$getConnector$p();
                            if (connector == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("connector");
                                connector = null;
                            }
                            String setStatement = switch (setCounter.WhenMappings.$EnumSwitchMapping$0[connector.getType().ordinal()]) {
                                case 1 -> "INSERT INTO ridecount_total (ride_id, player_uuid, total)\nVALUES (?, ?, ?)\nON DUPLICATE KEY UPDATE total = ?";
                                case 2 -> "INSERT INTO ridecount_total (ride_id, player_uuid, total)\nVALUES (?, ?, ?)\nON CONFLICT DO UPDATE SET total = ?";
                                default -> throw new NoWhenBranchMatchedException();
                            };
                            PreparedStatement stmt = it.prepareStatement(setStatement);
                            stmt.setString(1, string);
                            stmt.setString(2, string2);
                            stmt.setInt(3, n);
                            stmt.setInt(4, n);
                            int n2 = stmt.executeUpdate();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                        this.label = 1;
                        Object object2 = Database.INSTANCE.getTotalRidecount(this.$uuid, this.$rideId, this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super RidecountTotalRecord> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object incrementCounter(@NotNull String uuid, @NotNull String rideId, @NotNull Continuation<? super RidecountTotalRecord> $completion) {
        return BuildersKt.withContext(Ridecounters.Companion.getAsyncDispatcher(), (Function2)new Function2<CoroutineScope, Continuation<? super RidecountTotalRecord>, Object>(uuid, rideId, null){
            int label;
            final /* synthetic */ String $uuid;
            final /* synthetic */ String $rideId;
            {
                this.$uuid = $uuid;
                this.$rideId = $rideId;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        AutoCloseable autoCloseable = Database.access$connection(Database.INSTANCE);
                        String string = this.$rideId;
                        String string2 = this.$uuid;
                        Throwable throwable = null;
                        try {
                            Connection it = (Connection)autoCloseable;
                            boolean bl = false;
                            it.setAutoCommit(false);
                            Connector connector = Database.access$getConnector$p();
                            if (connector == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("connector");
                                connector = null;
                            }
                            String incrementStatement = switch (incrementCounter.WhenMappings.$EnumSwitchMapping$0[connector.getType().ordinal()]) {
                                case 1 -> "INSERT INTO ridecount_total (ride_id, player_uuid)\nVALUES (?, ?)\nON DUPLICATE KEY UPDATE total = total + 1";
                                case 2 -> "INSERT INTO ridecount_total (ride_id, player_uuid)\nVALUES (?, ?)\nON CONFLICT DO UPDATE SET total = total + 1";
                                default -> throw new NoWhenBranchMatchedException();
                            };
                            PreparedStatement totalStmt = it.prepareStatement(incrementStatement);
                            totalStmt.setString(1, string);
                            totalStmt.setString(2, string2);
                            totalStmt.executeUpdate();
                            PreparedStatement dataStmt = it.prepareStatement("INSERT INTO ridecount_data (ride_id, player_uuid)\nVALUES (?, ?)");
                            dataStmt.setString(1, string);
                            dataStmt.setString(2, string2);
                            dataStmt.executeUpdate();
                            it.commit();
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                        this.label = 1;
                        Object object2 = Database.INSTANCE.getTotalRidecount(this.$uuid, this.$rideId, this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super RidecountTotalRecord> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object getTotalRidecount(@NotNull String uuid, @NotNull String rideId, @NotNull Continuation<? super RidecountTotalRecord> $completion) {
        return BuildersKt.withContext(Ridecounters.Companion.getAsyncDispatcher(), (Function2)new Function2<CoroutineScope, Continuation<? super RidecountTotalRecord>, Object>(uuid, rideId, null){
            int label;
            final /* synthetic */ String $uuid;
            final /* synthetic */ String $rideId;
            {
                this.$uuid = $uuid;
                this.$rideId = $rideId;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        RidecountTotalRecord record = null;
                        AutoCloseable autoCloseable = Database.access$connection(Database.INSTANCE);
                        String string = this.$uuid;
                        String string2 = this.$rideId;
                        Throwable throwable = null;
                        try {
                            PlayerRecord playerRecord;
                            RideRecord rideRecord;
                            Connection it = (Connection)autoCloseable;
                            boolean bl = false;
                            PreparedStatement stmt = it.prepareStatement("SELECT\n    r.id as ride_id,\n    r.name as ride_name,\n    r.altname as ride_altname,\n    p.uuid as player_uuid,\n    p.username as player_username,\n    p.hidden as player_hidden,\n    t.total as total\nFROM ridecount_total t\nJOIN rides r ON t.ride_id = r.id\nJOIN players p ON t.player_uuid = p.uuid\nWHERE t.player_uuid = ? AND t.ride_id = ?\nLIMIT 1");
                            stmt.setString(1, string);
                            stmt.setString(2, string2);
                            ResultSet resultSet = stmt.executeQuery();
                            if (!resultSet.next()) {
                                Object var16_13 = null;
                                return var16_13;
                            }
                            Intrinsics.checkNotNull(resultSet);
                            if (Database.access$mapRide(Database.INSTANCE, resultSet) == null) {
                                Object var15_14 = null;
                                return var15_14;
                            }
                            RideRecord ride = rideRecord;
                            if (Database.access$mapPlayer(Database.INSTANCE, resultSet) == null) {
                                Object var14_16 = null;
                                return var14_16;
                            }
                            PlayerRecord player = playerRecord;
                            int total = resultSet.getInt("total");
                            record = new RidecountTotalRecord(player, ride, total);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                        return record;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super RidecountTotalRecord> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object getTopTotalRidecounter(@NotNull String rideId, int limit, @NotNull Continuation<? super RidecountTopRecord> $completion) {
        return BuildersKt.withContext(Ridecounters.Companion.getAsyncDispatcher(), (Function2)new Function2<CoroutineScope, Continuation<? super RidecountTopRecord>, Object>(rideId, limit, null){
            int label;
            final /* synthetic */ String $rideId;
            final /* synthetic */ int $limit;
            {
                this.$rideId = $rideId;
                this.$limit = $limit;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        RideRecord ride = null;
                        List data = new ArrayList<E>();
                        AutoCloseable autoCloseable = Database.access$connection(Database.INSTANCE);
                        String string = this.$rideId;
                        int n = this.$limit;
                        Throwable throwable = null;
                        try {
                            RideRecord rideRecord;
                            Connection it = (Connection)autoCloseable;
                            boolean bl = false;
                            PreparedStatement rideStmt = it.prepareStatement("SELECT id as ride_id, name as ride_name, altname as ride_altname FROM rides WHERE id = ?");
                            rideStmt.setString(1, string);
                            ResultSet rideResult = rideStmt.executeQuery();
                            if (!rideResult.next()) {
                                Object var16_14 = null;
                                return var16_14;
                            }
                            Intrinsics.checkNotNull(rideResult);
                            if (Database.access$mapRide(Database.INSTANCE, rideResult) == null) {
                                Object var15_15 = null;
                                return var15_15;
                            }
                            ride = rideRecord;
                            PreparedStatement stmt = it.prepareStatement("                SELECT\n                    p.uuid as player_uuid,\n                    p.username as player_username,\n                    p.hidden as player_hidden,\n                    t.total as total\n                FROM ridecount_total t\n                JOIN players p ON p.uuid = t.player_uuid\n                WHERE t.ride_id = ? AND p.hidden = false\n                ORDER BY t.total DESC\n                LIMIT ?");
                            stmt.setString(1, string);
                            stmt.setInt(2, n);
                            ResultSet resultSet = stmt.executeQuery();
                            while (resultSet.next()) {
                                PlayerRecord player;
                                Intrinsics.checkNotNull(resultSet);
                                if (Database.access$mapPlayer(Database.INSTANCE, resultSet) == null) continue;
                                data.add(new RidecountTotalRecord(player, ride, resultSet.getInt("total")));
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                        return new RidecountTopRecord(ride, CollectionsKt.toSet(data));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super RidecountTopRecord> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object savePlayer(@NotNull Player player, @NotNull Continuation<? super Integer> $completion) {
        return BuildersKt.withContext(Ridecounters.Companion.getAsyncDispatcher(), (Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(player, null){
            int label;
            final /* synthetic */ Player $player;
            {
                this.$player = $player;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Integer n;
                        ResultKt.throwOnFailure($result);
                        AutoCloseable autoCloseable = Database.access$connection(Database.INSTANCE);
                        Player player = this.$player;
                        Throwable throwable = null;
                        try {
                            Connection it = (Connection)autoCloseable;
                            boolean bl = false;
                            Connector connector = Database.access$getConnector$p();
                            if (connector == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("connector");
                                connector = null;
                            }
                            String saveStmt = switch (savePlayer.WhenMappings.$EnumSwitchMapping$0[connector.getType().ordinal()]) {
                                case 1 -> "INSERT INTO players (uuid, username) VALUES (?, ?) ON DUPLICATE KEY UPDATE username = ?";
                                case 2 -> "INSERT INTO players (uuid, username) VALUES (?, ?) ON CONFLICT DO UPDATE SET username = ?";
                                default -> throw new NoWhenBranchMatchedException();
                            };
                            PreparedStatement stmt = it.prepareStatement(saveStmt);
                            stmt.setString(1, player.getUniqueId().toString());
                            stmt.setString(2, player.getName());
                            stmt.setString(3, player.getName());
                            n = Boxing.boxInt(stmt.executeUpdate());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                        return n;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object getRides(@NotNull String idMatching, @NotNull Continuation<? super List<RideRecord>> $completion) {
        return BuildersKt.withContext(Ridecounters.Companion.getAsyncDispatcher(), (Function2)new Function2<CoroutineScope, Continuation<? super List<RideRecord>>, Object>(idMatching, null){
            int label;
            final /* synthetic */ String $idMatching;
            {
                this.$idMatching = $idMatching;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        List list = new ArrayList<E>();
                        AutoCloseable autoCloseable = Database.access$connection(Database.INSTANCE);
                        String string = this.$idMatching;
                        Throwable throwable = null;
                        try {
                            Connection it = (Connection)autoCloseable;
                            boolean bl = false;
                            PreparedStatement stmt = it.prepareStatement("SELECT id as ride_id, name as ride_name, altname as ride_altname FROM rides WHERE id LIKE ? LIMIT 20");
                            stmt.setString(1, "%" + string + "%");
                            ResultSet results = stmt.executeQuery();
                            while (results.next()) {
                                Intrinsics.checkNotNull(results);
                                RideRecord rideRecord = Database.access$mapRide(Database.INSTANCE, results);
                                if (rideRecord == null) continue;
                                list.add(rideRecord);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                        return list;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<RideRecord>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object getRides(int limit, int offset, @NotNull Continuation<? super List<RideRecord>> $completion) {
        return BuildersKt.withContext(Ridecounters.Companion.getAsyncDispatcher(), (Function2)new Function2<CoroutineScope, Continuation<? super List<? extends RideRecord>>, Object>(limit, offset, null){
            int label;
            final /* synthetic */ int $limit;
            final /* synthetic */ int $offset;
            {
                this.$limit = $limit;
                this.$offset = $offset;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        List list = new ArrayList<E>();
                        AutoCloseable autoCloseable = Database.access$connection(Database.INSTANCE);
                        int n = this.$limit;
                        int n2 = this.$offset;
                        Throwable throwable = null;
                        try {
                            Connection it = (Connection)autoCloseable;
                            boolean bl = false;
                            PreparedStatement stmt = it.prepareStatement("SELECT id as ride_id, name as ride_name, altname as ride_altname FROM rides LIMIT ? OFFSET ?");
                            stmt.setInt(1, n);
                            stmt.setInt(2, n2);
                            ResultSet results = stmt.executeQuery();
                            while (results.next()) {
                                Intrinsics.checkNotNull(results);
                                RideRecord rideRecord = Database.access$mapRide(Database.INSTANCE, results);
                                if (rideRecord == null) continue;
                                list.add(rideRecord);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                        return CollectionsKt.toList(list);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<RideRecord>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object getRide(@NotNull String rideId, @NotNull Continuation<? super RideRecord> $completion) {
        return BuildersKt.withContext(Ridecounters.Companion.getAsyncDispatcher(), (Function2)new Function2<CoroutineScope, Continuation<? super RideRecord>, Object>(rideId, null){
            int label;
            final /* synthetic */ String $rideId;
            {
                this.$rideId = $rideId;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        RideRecord ride = null;
                        AutoCloseable autoCloseable = Database.access$connection(Database.INSTANCE);
                        String string = this.$rideId;
                        Throwable throwable = null;
                        try {
                            RideRecord rideRecord;
                            Connection it = (Connection)autoCloseable;
                            boolean bl = false;
                            PreparedStatement stmt = it.prepareStatement("SELECT id as ride_id, name as ride_name, altname as ride_altname FROM rides WHERE id = ?");
                            stmt.setString(1, string);
                            ResultSet resultSet = stmt.executeQuery();
                            if (resultSet.next()) {
                                Intrinsics.checkNotNull(resultSet);
                                rideRecord = Database.access$mapRide(Database.INSTANCE, resultSet);
                            } else {
                                rideRecord = null;
                            }
                            ride = rideRecord;
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                        return ride;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super RideRecord> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object changeName(@NotNull String rideId, @NotNull String name, @NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext(Ridecounters.Companion.getAsyncDispatcher(), (Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(name, rideId, null){
            int label;
            final /* synthetic */ String $name;
            final /* synthetic */ String $rideId;
            {
                this.$name = $name;
                this.$rideId = $rideId;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        AutoCloseable autoCloseable = Database.access$connection(Database.INSTANCE);
                        String string = this.$name;
                        String string2 = this.$rideId;
                        Throwable throwable = null;
                        try {
                            Connection it = (Connection)autoCloseable;
                            boolean bl = false;
                            PreparedStatement stmt = it.prepareStatement("UPDATE rides SET name = ? WHERE id = ?");
                            stmt.setString(1, string);
                            stmt.setString(2, string2);
                            Boolean bl2 = Boxing.boxBoolean(stmt.executeUpdate() > 0);
                            return bl2;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object changeAltName(@NotNull String rideId, @NotNull String name, @NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext(Ridecounters.Companion.getAsyncDispatcher(), (Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(name, rideId, null){
            int label;
            final /* synthetic */ String $name;
            final /* synthetic */ String $rideId;
            {
                this.$name = $name;
                this.$rideId = $rideId;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        AutoCloseable autoCloseable = Database.access$connection(Database.INSTANCE);
                        String string = this.$name;
                        String string2 = this.$rideId;
                        Throwable throwable = null;
                        try {
                            Connection it = (Connection)autoCloseable;
                            boolean bl = false;
                            PreparedStatement stmt = it.prepareStatement("UPDATE rides SET altname = ? WHERE id = ?");
                            stmt.setString(1, string);
                            stmt.setString(2, string2);
                            Boolean bl2 = Boxing.boxBoolean(stmt.executeUpdate() > 0);
                            return bl2;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final PlayerRecord mapPlayer(ResultSet resultSet) {
        PlayerRecord playerRecord;
        try {
            UUID uUID = UUID.fromString(resultSet.getString("player_uuid"));
            Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
            String string = resultSet.getString("player_username");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            playerRecord = new PlayerRecord(uUID, string, resultSet.getBoolean("player_hidden"));
        }
        catch (Exception exception) {
            playerRecord = null;
        }
        return playerRecord;
    }

    private final RideRecord mapRide(ResultSet resultSet) {
        Object object;
        try {
            Object object2;
            Object $this$mapRide_u24lambda_u240;
            String string = resultSet.getString("ride_id");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String string2 = resultSet.getString("ride_name");
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            object = resultSet;
            String string3 = string2;
            String string4 = string;
            try {
                $this$mapRide_u24lambda_u240 = object;
                boolean bl = false;
                $this$mapRide_u24lambda_u240 = Result.constructor-impl($this$mapRide_u24lambda_u240.getString("ride_altname"));
            }
            catch (Throwable throwable) {
                $this$mapRide_u24lambda_u240 = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            object = object2 = $this$mapRide_u24lambda_u240;
            String string5 = (String)(Result.isFailure-impl(object) ? null : object);
            String string6 = string3;
            String string7 = string4;
            object = new RideRecord(string7, string6, string5);
        }
        catch (Exception exception) {
            object = null;
        }
        return object;
    }

    public static final /* synthetic */ Connection access$connection(Database $this) {
        return $this.connection();
    }

    public static final /* synthetic */ Connector access$getConnector$p() {
        return connector;
    }

    public static final /* synthetic */ RideRecord access$mapRide(Database $this, ResultSet resultSet) {
        return $this.mapRide(resultSet);
    }

    public static final /* synthetic */ PlayerRecord access$mapPlayer(Database $this, ResultSet resultSet) {
        return $this.mapPlayer(resultSet);
    }
}

