/*
 * Decompiled with CFR 0.152.
 */
package be.mrtibo.ridecounters.data;

import be.mrtibo.ridecounters.Ridecounters;
import be.mrtibo.ridecounters.data.DBType;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\u0014R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lbe/mrtibo/ridecounters/data/Connector;", "", "<init>", "()V", "type", "Lbe/mrtibo/ridecounters/data/DBType;", "getType", "()Lbe/mrtibo/ridecounters/data/DBType;", "hikariConfig", "Lcom/zaxxer/hikari/HikariConfig;", "getHikariConfig", "()Lcom/zaxxer/hikari/HikariConfig;", "dataSource", "Lcom/zaxxer/hikari/HikariDataSource;", "getConfig", "configure", "", "open", "close", "getConnection", "Ljava/sql/Connection;", "Ridecounters"})
public abstract class Connector {
    @NotNull
    private final HikariConfig hikariConfig = new HikariConfig();
    private HikariDataSource dataSource;

    @NotNull
    public abstract DBType getType();

    @NotNull
    public final HikariConfig getHikariConfig() {
        return this.hikariConfig;
    }

    @NotNull
    public final HikariConfig getConfig() {
        return this.hikariConfig;
    }

    public void configure() {
        this.hikariConfig.addDataSourceProperty("cachePrepStmts", "true");
        this.hikariConfig.addDataSourceProperty("prepStmtCacheSize", "250");
        this.hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        this.hikariConfig.setConnectionTimeout(Ridecounters.Companion.getINSTANCE().getConfig().getLong("database.connectionTimeout", 10000L));
        this.hikariConfig.setConnectionTestQuery("SELECT 1");
    }

    public final void open() {
        this.configure();
        this.dataSource = new HikariDataSource(this.hikariConfig);
    }

    public final void close() {
        HikariDataSource hikariDataSource = this.dataSource;
        if (hikariDataSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException("dataSource");
            hikariDataSource = null;
        }
        hikariDataSource.close();
    }

    @NotNull
    public final Connection getConnection() {
        HikariDataSource hikariDataSource = this.dataSource;
        if (hikariDataSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException("dataSource");
            hikariDataSource = null;
        }
        Connection connection = hikariDataSource.getConnection();
        Intrinsics.checkNotNullExpressionValue(connection, "getConnection(...)");
        return connection;
    }
}

