/*
 * Decompiled with CFR 0.152.
 */
package be.mrtibo.lib.cloud.type.range;

import be.mrtibo.lib.cloud.type.range.ByteRange;
import be.mrtibo.lib.cloud.type.range.ByteRangeImpl;
import be.mrtibo.lib.cloud.type.range.DoubleRange;
import be.mrtibo.lib.cloud.type.range.DoubleRangeImpl;
import be.mrtibo.lib.cloud.type.range.FloatRange;
import be.mrtibo.lib.cloud.type.range.FloatRangeImpl;
import be.mrtibo.lib.cloud.type.range.IntRange;
import be.mrtibo.lib.cloud.type.range.IntRangeImpl;
import be.mrtibo.lib.cloud.type.range.LongRange;
import be.mrtibo.lib.cloud.type.range.LongRangeImpl;
import be.mrtibo.lib.cloud.type.range.ShortRange;
import be.mrtibo.lib.cloud.type.range.ShortRangeImpl;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public interface Range<N extends Number> {
    public @NonNull N min();

    public @NonNull N max();

    public static @NonNull ByteRange byteRange(byte min, byte max) {
        return ByteRangeImpl.of(min, max);
    }

    public static @NonNull DoubleRange doubleRange(double min, double max) {
        return DoubleRangeImpl.of(min, max);
    }

    public static @NonNull FloatRange floatRange(float min, float max) {
        return FloatRangeImpl.of(min, max);
    }

    public static @NonNull IntRange intRange(int min, int max) {
        return IntRangeImpl.of(min, max);
    }

    public static @NonNull LongRange longRange(long min, long max) {
        return LongRangeImpl.of(min, max);
    }

    public static @NonNull ShortRange shortRange(short min, short max) {
        return ShortRangeImpl.of(min, max);
    }
}

