/*
 * Decompiled with CFR 0.152.
 */
package be.mrtibo.lib.cloud.annotations.assembler;

import be.mrtibo.lib.cloud.CommandManager;
import be.mrtibo.lib.cloud.annotations.assembler.FlagAssembler;
import be.mrtibo.lib.cloud.annotations.descriptor.FlagDescriptor;
import be.mrtibo.lib.cloud.component.CommandComponent;
import be.mrtibo.lib.cloud.description.Description;
import be.mrtibo.lib.cloud.parser.ArgumentParser;
import be.mrtibo.lib.cloud.parser.ParserRegistry;
import be.mrtibo.lib.cloud.parser.flag.CommandFlag;
import be.mrtibo.lib.cloud.permission.Permission;
import be.mrtibo.lib.cloud.suggestion.SuggestionProvider;
import com.bergerkiller.bukkit.common.dep.typetoken.GenericTypeReflector;
import com.bergerkiller.bukkit.common.dep.typetoken.TypeToken;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL, consumers={"be.mrtibo.lib.cloud.annotations.*"})
public final class FlagAssemblerImpl
implements FlagAssembler {
    private final CommandManager<?> commandManager;

    public FlagAssemblerImpl(@NonNull CommandManager<?> commandManager) {
        this.commandManager = commandManager;
    }

    @Override
    public @NonNull CommandFlag<?> assembleFlag(@NonNull FlagDescriptor descriptor2) {
        Description description = descriptor2.description() == null ? Description.empty() : descriptor2.description();
        Permission permission = descriptor2.permission() == null ? Permission.empty() : descriptor2.permission();
        CommandFlag.Builder<?, Void> builder = this.commandManager.flagBuilder(descriptor2.name()).withDescription(description).withAliases(descriptor2.aliases()).withPermission(permission);
        if (descriptor2.repeatable()) {
            builder = builder.asRepeatable();
        }
        if (descriptor2.parameter().getType().equals(Boolean.TYPE)) {
            return builder.build();
        }
        TypeToken<?> token = descriptor2.repeatable() && Collection.class.isAssignableFrom(descriptor2.parameter().getType()) ? TypeToken.get(GenericTypeReflector.getTypeParameter(descriptor2.parameter().getParameterizedType(), Collection.class.getTypeParameters()[0])) : TypeToken.get(descriptor2.parameter().getType());
        if (token.equals(TypeToken.get(Boolean.TYPE))) {
            return builder.build();
        }
        List<Annotation> annotations = Arrays.asList(descriptor2.parameter().getAnnotations());
        ParserRegistry<?> registry = this.commandManager.parserRegistry();
        ArgumentParser parser = descriptor2.parserName() == null ? (ArgumentParser)registry.createParser(token, registry.parseAnnotations(token, annotations)).orElse(null) : (ArgumentParser)registry.createParser(descriptor2.parserName(), registry.parseAnnotations(token, annotations)).orElse(null);
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Cannot find parser for type '%s' for flag '%s'", descriptor2.parameter().getType().getCanonicalName(), descriptor2.name()));
        }
        SuggestionProvider suggestionProvider = descriptor2.suggestions() != null ? (SuggestionProvider)registry.getSuggestionProvider(descriptor2.suggestions()).orElse(null) : null;
        CommandComponent.Builder componentBuilder = CommandComponent.builder();
        componentBuilder.commandManager(this.commandManager).name(descriptor2.name()).valueType(descriptor2.parameter().getType()).parser(parser);
        if (suggestionProvider != null) {
            componentBuilder.suggestionProvider(suggestionProvider);
        }
        return builder.withComponent(componentBuilder.build()).build();
    }
}

