/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer.selection;

import fr.mrmicky.worldeditselectionvisualizer.selection.PlayerSelection;
import fr.mrmicky.worldeditselectionvisualizer.selection.SelectionType;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PlayerVisualizerData {
    private final Map<SelectionType, PlayerSelection> enabledVisualizations = new EnumMap<SelectionType, PlayerSelection>(SelectionType.class);
    private final Player player;
    private volatile @Nullable Location clipboardLockLocation;
    private volatile boolean holdingSelectionItem = true;

    public PlayerVisualizerData(Player player) {
        this.player = Objects.requireNonNull(player, "player");
    }

    public Optional<PlayerSelection> getSelection(SelectionType type) {
        return Optional.ofNullable(this.enabledVisualizations.get((Object)type));
    }

    public Collection<PlayerSelection> getEnabledVisualizations() {
        return this.enabledVisualizations.values();
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isHoldingSelectionItem() {
        return this.holdingSelectionItem;
    }

    public void setHoldingSelectionItem(boolean holdingSelectionItem) {
        this.holdingSelectionItem = holdingSelectionItem;
    }

    public boolean isSelectionVisible(SelectionType type) {
        return this.enabledVisualizations.containsKey((Object)type);
    }

    public void toggleSelectionVisibility(SelectionType type, boolean enable) {
        if (!enable) {
            this.enabledVisualizations.remove((Object)type);
            return;
        }
        this.enabledVisualizations.computeIfAbsent(type, PlayerSelection::new);
    }

    public @Nullable Location getClipboardLockLocation() {
        return this.clipboardLockLocation;
    }

    public void setClipboardLockLocation(@Nullable Location location) {
        this.clipboardLockLocation = location;
    }
}

