/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer.geometry;

import fr.mrmicky.worldeditselectionvisualizer.config.SelectionConfig;
import fr.mrmicky.worldeditselectionvisualizer.geometry.Shape;
import fr.mrmicky.worldeditselectionvisualizer.math.Vector3d;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class VerticalEllipse
implements Shape {
    private final Vector3d center;
    private final Vector3d radius;
    private final int points;
    private final double[] cos;
    private final double[] y;

    public VerticalEllipse(Vector3d center, Vector3d radius, SelectionConfig config) {
        this.center = Objects.requireNonNull(center, "center");
        this.radius = Objects.requireNonNull(radius, "radius");
        double maxRadius = Math.max(radius.getX(), Math.max(radius.getY(), radius.getZ()));
        this.points = Math.abs((int)Math.round(maxRadius * (Math.PI * 2) / config.getPointsDistance()));
        double increment = Math.PI * 2 / (double)Math.max(1, this.points);
        this.cos = new double[this.points];
        this.y = new double[this.points];
        for (int i = 0; i < this.points; ++i) {
            double angle = (double)i * increment;
            this.cos[i] = Math.cos(angle);
            this.y[i] = center.getY() + Math.sin(angle) * radius.getY();
        }
    }

    @Override
    public void render(Shape.VectorRenderer renderer) {
        for (int i = 0; i < this.points; ++i) {
            double x = this.center.getX() + this.cos[i] * this.radius.getX();
            double z = this.center.getZ() + this.cos[i] * this.radius.getZ();
            renderer.render(x, this.y[i], z);
        }
    }
}

