/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer.geometry;

import fr.mrmicky.worldeditselectionvisualizer.config.SelectionConfig;
import fr.mrmicky.worldeditselectionvisualizer.geometry.Shape;
import fr.mrmicky.worldeditselectionvisualizer.math.Vector3d;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Ellipse
implements Shape {
    private final Vector3d center;
    private final int points;
    private final double[] x;
    private final double[] z;

    public Ellipse(Vector3d center, Vector3d radius, SelectionConfig config) {
        this.center = Objects.requireNonNull(center, "center");
        double maxRadius = Math.max(radius.getX(), Math.max(radius.getY(), radius.getZ()));
        this.points = Math.abs((int)Math.round(maxRadius * (Math.PI * 2) / config.getPointsDistance()));
        double increment = Math.PI * 2 / (double)Math.max(1, this.points);
        this.x = new double[this.points];
        this.z = new double[this.points];
        for (int i = 0; i < this.points; ++i) {
            double angle = (double)i * increment;
            this.x[i] = center.getX() + Math.cos(angle) * radius.getX();
            this.z[i] = center.getZ() + Math.sin(angle) * radius.getZ();
        }
    }

    @Override
    public void render(Shape.VectorRenderer renderer) {
        for (int i = 0; i < this.points; ++i) {
            renderer.render(this.x[i], this.center.getY(), this.z[i]);
        }
    }
}

