/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer.compat;

import fr.mrmicky.worldeditselectionvisualizer.compat.ScheduledTask;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface SchedulerAdapter {
    public void execute(Runnable var1);

    public ScheduledTask scheduleGlobalRepeating(Runnable var1, long var2, long var4);

    public ScheduledTask scheduleAsyncRepeating(Runnable var1, long var2, long var4);

    public void executeAsync(Runnable var1);

    public void teleport(Player var1, Location var2);

    public String name();

    public static SchedulerAdapter create(Plugin plugin) {
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.EntityScheduler");
            return new FoliaSchedulerAdapter(plugin);
        }
        catch (ClassNotFoundException e) {
            return new BukkitSchedulerAdapter(plugin);
        }
    }

    public static class FoliaSchedulerAdapter
    implements SchedulerAdapter {
        private final Plugin plugin;

        public FoliaSchedulerAdapter(Plugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public void execute(Runnable task) {
            this.plugin.getServer().getGlobalRegionScheduler().run(this.plugin, t -> task.run());
        }

        @Override
        public ScheduledTask scheduleGlobalRepeating(Runnable task, long delay, long period) {
            return () -> ((io.papermc.paper.threadedregions.scheduler.ScheduledTask)this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate(this.plugin, t -> task.run(), delay, period)).cancel();
        }

        @Override
        public ScheduledTask scheduleAsyncRepeating(Runnable task, long delay, long period) {
            return () -> ((io.papermc.paper.threadedregions.scheduler.ScheduledTask)this.plugin.getServer().getAsyncScheduler().runAtFixedRate(this.plugin, t -> task.run(), delay * 50L, period * 50L, TimeUnit.MILLISECONDS)).cancel();
        }

        @Override
        public void executeAsync(Runnable task) {
            this.plugin.getServer().getAsyncScheduler().runNow(this.plugin, t -> task.run());
        }

        @Override
        public void teleport(Player player, Location location) {
            player.teleportAsync(location);
        }

        @Override
        public String name() {
            return "Folia";
        }
    }

    public static class BukkitSchedulerAdapter
    implements SchedulerAdapter {
        private final Plugin plugin;

        public BukkitSchedulerAdapter(Plugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public void execute(Runnable task) {
            this.plugin.getServer().getScheduler().runTask(this.plugin, task);
        }

        @Override
        public ScheduledTask scheduleGlobalRepeating(Runnable task, long delay, long period) {
            return () -> ((BukkitTask)this.plugin.getServer().getScheduler().runTaskTimer(this.plugin, task, delay, period)).cancel();
        }

        @Override
        public ScheduledTask scheduleAsyncRepeating(Runnable task, long delay, long period) {
            return () -> ((BukkitTask)this.plugin.getServer().getScheduler().runTaskTimerAsynchronously(this.plugin, task, delay, period)).cancel();
        }

        @Override
        public void executeAsync(Runnable task) {
            this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, task);
        }

        @Override
        public void teleport(Player player, Location location) {
            player.teleport(location);
        }

        @Override
        public String name() {
            return "Bukkit";
        }
    }
}

