/*
 * Decompiled with CFR 0.152.
 */
package me.moros.tasker.executor;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import me.moros.tasker.Task;
import me.moros.tasker.executor.TickAdapter;
import org.jspecify.annotations.Nullable;

public interface TaskExecutor
extends TickAdapter,
Executor {
    @Override
    default public void execute(Runnable command) {
        this.submit(command, 0);
    }

    default public CompletableFuture<?> submit(Runnable task) {
        return this.submit(this.toSupplier(task), 0);
    }

    default public <V> CompletableFuture<@Nullable V> submit(Supplier<@Nullable V> task) {
        return this.submit(task, 0);
    }

    default public CompletableFuture<?> submit(Runnable task, int ticks) {
        return this.submit(this.toSupplier(task), ticks);
    }

    public <V> CompletableFuture<@Nullable V> submit(Supplier<@Nullable V> var1, int var2);

    default public CompletableFuture<?> submit(Runnable task, long delay, TimeUnit unit) {
        return this.submit(this.toSupplier(task), delay, unit);
    }

    public <V> CompletableFuture<@Nullable V> submit(Supplier<@Nullable V> var1, long var2, TimeUnit var4);

    default public Task repeat(Runnable task, int periodTicks) {
        return this.repeat(task, 0, periodTicks);
    }

    default public Task repeat(Runnable task, long period, TimeUnit unit) {
        return this.repeat(task, 0L, period, unit);
    }

    public Task repeat(Runnable var1, int var2, int var3);

    public Task repeat(Runnable var1, long var2, long var4, TimeUnit var6);

    private Supplier<?> toSupplier(Runnable task) {
        Objects.requireNonNull(task);
        return () -> {
            task.run();
            return null;
        };
    }

    public boolean isValid();

    public void shutdown();
}

