/*
 * Decompiled with CFR 0.152.
 */
package me.moros.tasker.executor;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import me.moros.tasker.Task;
import me.moros.tasker.executor.AsyncExecutor;
import me.moros.tasker.executor.FutureWrapper;
import org.jspecify.annotations.Nullable;

public class SimpleAsyncExecutor
implements AsyncExecutor {
    private final ScheduledThreadPoolExecutor scheduler;
    private final ExecutorService executor;

    public SimpleAsyncExecutor(ExecutorService executor) {
        DaemonThreadFactory threadFactory = new DaemonThreadFactory("TaskerScheduler");
        this.scheduler = new ScheduledThreadPoolExecutor(1, threadFactory);
        this.scheduler.setRemoveOnCancelPolicy(true);
        this.executor = Objects.requireNonNull(executor);
    }

    public SimpleAsyncExecutor() {
        this(Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() / 2)));
    }

    private Executor delayedExecutor(long delay, TimeUnit unit) {
        return delay <= 0L ? this.executor : new Delayer(this.scheduler, this.executor, delay, unit);
    }

    @Override
    public <V> CompletableFuture<@Nullable V> submit(Supplier<@Nullable V> task, long delay, TimeUnit unit) {
        Objects.requireNonNull(task);
        this.checkValid();
        return CompletableFuture.supplyAsync(task, this.delayedExecutor(delay, unit));
    }

    @Override
    public Task repeat(Runnable task, long delay, long period, TimeUnit unit) {
        Objects.requireNonNull(task);
        this.checkValid();
        int periodTicks = this.toTicks(period, unit);
        RunnableFuture future = (RunnableFuture)((Object)this.scheduler.scheduleAtFixedRate(() -> this.executor.execute(task), delay, period, unit));
        return new FutureWrapper(future, periodTicks);
    }

    @Override
    public boolean isValid() {
        return !this.executor.isShutdown();
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        this.scheduler.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            this.scheduler.shutdownNow();
        }
    }

    protected void checkValid() {
        if (!this.isValid()) {
            throw new RejectedExecutionException("Cannot execute now!");
        }
    }

    private record DaemonThreadFactory(String name) implements ThreadFactory
    {
        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.name);
            t.setDaemon(true);
            t.setName(this.name);
            return t;
        }
    }

    private record Delayer(ScheduledExecutorService del, Executor ex, long delay, TimeUnit unit) implements Executor
    {
        @Override
        public void execute(Runnable command) {
            this.del.schedule(() -> this.ex.execute(command), this.delay, this.unit);
        }
    }
}

