/*
 * Decompiled with CFR 0.152.
 */
package me.moros.tasker;

import java.util.Objects;
import java.util.function.Consumer;
import me.moros.tasker.Expiring;
import me.moros.tasker.HierarchicalTimerWheel;
import me.moros.tasker.LinkedTask;
import me.moros.tasker.SimpleTimerWheel;
import me.moros.tasker.Task;

public interface TimerWheel {
    public int currentTick();

    public void advance();

    default public Task schedule(Consumer<? super Task> consumer, int delay, int period) {
        Objects.requireNonNull(consumer);
        LinkedTask task = new LinkedTask(consumer, period);
        return this.schedule(task, delay);
    }

    public <T extends Expiring> T schedule(T var1, int var2);

    public void shutdown(boolean var1);

    public static TimerWheel hierarchical() {
        return new HierarchicalTimerWheel();
    }

    public static TimerWheel simple(int capacity) {
        return new SimpleTimerWheel(Math.max(1, capacity));
    }
}

