/*
 * Decompiled with CFR 0.152.
 */
package me.moros.tasker;

import java.util.function.Consumer;
import me.moros.tasker.Expiring;
import org.jspecify.annotations.Nullable;

sealed class TaskList {
    private @Nullable Expiring first;
    private @Nullable Expiring last;

    TaskList() {
    }

    final @Nullable Expiring unlinkFirst() {
        Expiring toRemove = this.first;
        if (toRemove != null) {
            Expiring next = toRemove.next();
            toRemove.next(null);
            this.first = next;
            if (next == null) {
                this.last = null;
            } else {
                next.previous(null);
            }
            toRemove.parent = null;
        }
        return toRemove;
    }

    final void unlink(Expiring node) {
        Expiring next = node.next();
        Expiring prev = node.previous();
        if (prev == null) {
            this.first = next;
        } else {
            prev.next(next);
            node.previous(null);
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.previous(prev);
            node.next(null);
        }
        node.parent = null;
    }

    final @Nullable Expiring first() {
        return this.first;
    }

    void add(Expiring node) {
        for (Expiring check = this.first; check != null; check = check.next()) {
            if (node.compareTo(check) > 0) continue;
            this.linkBefore(node, check);
            return;
        }
        this.linkLast(node);
    }

    final void linkBefore(Expiring node, Expiring next) {
        Expiring prev = next.previous();
        node.previous(prev);
        node.next(next);
        next.previous(node);
        if (prev == null) {
            this.first = node;
        } else {
            prev.next(node);
        }
    }

    final void linkLast(Expiring node) {
        Expiring oldLast = this.last;
        node.previous(oldLast);
        node.next(null);
        this.last = node;
        if (oldLast == null) {
            this.first = node;
        } else {
            oldLast.next(node);
        }
    }

    final void clear(Consumer<? super Expiring> action) {
        Expiring node = this.first;
        while (node != null) {
            Expiring next = node.next();
            node.next(null);
            node.previous(null);
            node.parent = null;
            action.accept(node);
            node = next;
        }
        this.last = null;
        this.first = null;
    }

    static final class PendingTaskList
    extends TaskList {
        PendingTaskList() {
        }

        @Override
        void add(Expiring node) {
            this.linkLast(node);
        }
    }
}

