/*
 * Decompiled with CFR 0.152.
 */
package me.moros.math;

import me.moros.math.DoubleQuaternion;
import me.moros.math.Position;
import me.moros.math.Quaternion;
import me.moros.math.Vector3d;

public interface Rotation
extends Quaternion {
    public static Rotation from(Vector3d axis, double angle) throws IllegalArgumentException {
        double norm = axis.length();
        if (norm == 0.0) {
            throw new IllegalArgumentException();
        }
        double halfAngle = -0.5 * angle;
        double coeff = Math.sin(halfAngle) / norm;
        return new DoubleQuaternion(Math.cos(halfAngle), coeff * axis.x(), coeff * axis.y(), coeff * axis.z());
    }

    public double[][] getMatrix();

    default public Vector3d applyTo(Position p) {
        return this.applyTo(p.x(), p.y(), p.z());
    }

    default public void applyTo(double[] in, double[] out) {
        Vector3d result = this.applyTo(in[0], in[1], in[2]);
        out[0] = result.x();
        out[1] = result.y();
        out[2] = result.z();
    }

    public Vector3d applyTo(double var1, double var3, double var5);

    default public Vector3d applyInverseTo(Position p) {
        return this.applyInverseTo(p.x(), p.y(), p.z());
    }

    default public void applyInverseTo(double[] in, double[] out) {
        Vector3d result = this.applyInverseTo(in[0], in[1], in[2]);
        out[0] = result.x();
        out[1] = result.y();
        out[2] = result.z();
    }

    public Vector3d applyInverseTo(double var1, double var3, double var5);

    public Rotation applyTo(Rotation var1);

    public Rotation applyInverseTo(Rotation var1);
}

