/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.paper.service;

import java.util.UUID;
import me.moros.gaia.common.command.CommandPermissions;
import me.moros.gaia.common.locale.Message;
import me.moros.gaia.common.service.AbstractSelectionService;
import me.moros.math.Vector3i;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class GaiaSelectionService
extends AbstractSelectionService
implements Listener {
    public GaiaSelectionService(JavaPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.useItemInHand() == Event.Result.DENY || event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        Key level = player.getWorld().key();
        Action action = event.getAction();
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null || player.getInventory().getItemInMainHand().getType() != Material.WOODEN_AXE) {
            return;
        }
        if (!player.hasPermission(CommandPermissions.CREATE.toString())) {
            return;
        }
        Vector3i pos = Vector3i.of(clickedBlock.getX(), clickedBlock.getY(), clickedBlock.getZ());
        if (action == Action.LEFT_CLICK_BLOCK) {
            this.registerClick(uuid, level, pos);
            Message.SELECTION_FIRST.send((Audience)player, pos.toString());
            event.setCancelled(true);
        } else if (action == Action.RIGHT_CLICK_BLOCK) {
            this.registerInteraction(uuid, level, pos);
            Message.SELECTION_SECOND.send((Audience)player, pos.toString());
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.invalidate(event.getPlayer().getUniqueId());
    }
}

