/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public final class Debounced<R> {
    private final Supplier<R> supplier;
    private final long delay;
    private final TimeUnit timeUnit;
    private final CompletableFuture<R> future;
    private final AtomicReference<CompletableFuture<R>> taskRef;

    private Debounced(Supplier<R> supplier, long delay, TimeUnit timeUnit) {
        this.supplier = supplier;
        this.delay = delay;
        this.timeUnit = timeUnit;
        this.future = new CompletableFuture();
        this.taskRef = new AtomicReference();
    }

    public CompletableFuture<R> future() {
        return this.future;
    }

    public CompletableFuture<R> request() {
        this.taskRef.updateAndGet(this::createOrReschedule);
        return this.future;
    }

    private CompletableFuture<R> createOrReschedule(@Nullable CompletableFuture<R> taskFuture) {
        if (taskFuture != null) {
            taskFuture.cancel(false);
        }
        Executor delayedExecutor = CompletableFuture.delayedExecutor(this.delay, this.timeUnit);
        CompletableFuture<R> newFuture = CompletableFuture.supplyAsync(this.supplier, delayedExecutor);
        newFuture.thenAccept(this.future::complete);
        return newFuture;
    }

    public static <R> Debounced<R> create(Supplier<R> supplier, long delay, TimeUnit timeUnit) {
        return new Debounced<R>(supplier, delay, timeUnit);
    }

    public static Debounced<?> create(Runnable runnable, long delay, TimeUnit timeUnit) {
        return Debounced.create(() -> {
            runnable.run();
            return null;
        }, delay, timeUnit);
    }
}

