/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.storage.serializer;

import java.lang.reflect.Type;
import me.moros.gaia.api.arena.Point;
import me.moros.gaia.api.util.ChunkUtil;
import me.moros.math.Vector3d;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class PointSerializer
implements TypeSerializer<Point> {
    static final PointSerializer INSTANCE = new PointSerializer();

    private PointSerializer() {
    }

    public Point deserialize(Type type, ConfigurationNode source) throws SerializationException {
        double[] array = (double[])source.get(double[].class, (Object)new double[0]);
        if (array.length != 5) {
            throw new SerializationException("Invalid Point: Expected array length 5");
        }
        Vector3d pos = Vector3d.of(array[0], array[1], array[2]);
        if (!ChunkUtil.isValidPosition(pos)) {
            throw new SerializationException("Invalid Vector %s exceeds bounds!".formatted(pos));
        }
        float yaw = (float)array[3];
        float pitch = (float)array[4];
        return Point.of(pos, PointSerializer.normalizeYaw(yaw), PointSerializer.normalizePitch(pitch));
    }

    public void serialize(Type type, @Nullable Point point, ConfigurationNode target) throws SerializationException {
        if (point == null) {
            target.raw(null);
            return;
        }
        target.set((Object)new double[]{point.x(), point.y(), point.z(), PointSerializer.normalizeYaw(point.yaw()), PointSerializer.normalizePitch(point.pitch())});
    }

    private static float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) >= 180.0f) {
            yaw -= 360.0f;
        } else if (yaw < -180.0f) {
            yaw += 360.0f;
        }
        return yaw;
    }

    private static float normalizePitch(float pitch) {
        return Math.clamp(pitch, -90.0f, 90.0f);
    }
}

