/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.storage.serializer;

import java.lang.reflect.Type;
import java.util.List;
import me.moros.gaia.api.arena.Arena;
import me.moros.gaia.api.arena.Point;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.arena.region.Region;
import me.moros.gaia.common.storage.serializer.AbstractSerializer;
import me.moros.math.Vector3i;
import net.kyori.adventure.key.Key;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

final class ArenaSerializer
extends AbstractSerializer<Arena> {
    static final ArenaSerializer INSTANCE = new ArenaSerializer();
    private static final int VERSION_VALUE = 2;
    private static final String VERSION = "version";
    private static final String NAME = "name";
    private static final String LEVEL = "level";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String AMOUNT = "amount";
    private static final String CHUNKS = "chunks";
    private static final String POINTS = "points";

    private ArenaSerializer() {
    }

    public Arena deserialize(Type type, ConfigurationNode source) throws SerializationException {
        List chunks;
        int version = ArenaSerializer.nonVirtualNode(source, VERSION).getInt();
        if (version != 2) {
            throw new SerializationException("Unknown data version, expected %d but found %d".formatted(2, version));
        }
        String name = ArenaSerializer.nonVirtualNode(source, NAME).getString();
        Key level = Key.key((String)ArenaSerializer.nonVirtualNode(source, LEVEL).getString(""));
        Vector3i min = (Vector3i)ArenaSerializer.nonVirtualNode(source, MIN).get(Vector3i.class);
        Vector3i max = (Vector3i)ArenaSerializer.nonVirtualNode(source, MAX).get(Vector3i.class);
        if (name == null || min == null || max == null) {
            throw new SerializationException("A name, level, min and max are required to deserialize an Arena");
        }
        Region region = Region.of(min, max);
        int amount = ArenaSerializer.nonVirtualNode(source, AMOUNT).getInt();
        if (amount != (chunks = ArenaSerializer.nonVirtualNode(source, CHUNKS).getList(ChunkRegion.Validated.class, List::of)).size()) {
            throw new SerializationException("Expected %d chunk regions but found %d".formatted(amount, chunks.size()));
        }
        List points = ArenaSerializer.nonVirtualNode(source, POINTS).getList(Point.class, List::of);
        return Arena.builder().name(name).level(level).region(region).chunks(chunks).points(points).build();
    }

    public void serialize(Type type, @Nullable Arena arena, ConfigurationNode target) throws SerializationException {
        if (arena == null) {
            target.raw(null);
            return;
        }
        target.node(new Object[]{VERSION}).set((Object)2);
        target.node(new Object[]{NAME}).set((Object)arena.name());
        target.node(new Object[]{LEVEL}).set((Object)arena.level().asString());
        target.node(new Object[]{MIN}).set(Vector3i.class, (Object)arena.region().min());
        target.node(new Object[]{MAX}).set(Vector3i.class, (Object)arena.region().max());
        target.node(new Object[]{AMOUNT}).set((Object)arena.chunks().size());
        target.node(new Object[]{CHUNKS}).setList(ChunkRegion.Validated.class, arena.chunks());
        target.node(new Object[]{POINTS}).setList(Point.class, arena.points());
    }
}

