/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.storage;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.CRC32C;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.GZIPOutputStream;
import me.moros.gaia.api.arena.Arena;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.chunk.ChunkPosition;
import me.moros.gaia.api.chunk.Snapshot;
import me.moros.gaia.api.storage.Storage;
import me.moros.gaia.common.storage.ChecksumMismatchException;
import me.moros.gaia.common.storage.SchemWriter;
import me.moros.gaia.common.storage.serializer.Serializers;
import me.moros.tasker.executor.AsyncExecutor;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;
import org.spongepowered.configurate.reference.ConfigurationReference;

public final class FileStorage
implements Storage {
    public static final Supplier<Checksum> ALGORITHM = CRC32C::new;
    private static final String ARENA_DIR = "arenas";
    private static final String ARENA_META = "meta.json";
    private static final String CHUNK_NAME_FORMAT = "c.%d.%d.schem";
    private final AsyncExecutor executor;
    private final Logger logger;
    private final Path container;
    private final Semaphore semaphore;

    private FileStorage(AsyncExecutor executor, Logger logger, Path container) {
        this.executor = executor;
        this.logger = logger;
        this.container = container;
        this.semaphore = new Semaphore(Math.max(Runtime.getRuntime().availableProcessors(), 2));
    }

    public static Storage createInstance(AsyncExecutor executor, Logger logger, Path path) {
        Path container;
        Objects.requireNonNull(executor);
        Objects.requireNonNull(logger);
        Objects.requireNonNull(path);
        try {
            container = Files.createDirectories(path.resolve(ARENA_DIR), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not create %s directory! Aborting loading.", ARENA_DIR), e);
        }
        return new FileStorage(executor, logger, container);
    }

    private Path arenaPath(String name) {
        return this.container.resolve(name);
    }

    private Path arenaMeta(String name) {
        return this.arenaPath(name).resolve(ARENA_META);
    }

    private Path chunkPath(String name, ChunkPosition position) {
        return this.arenaPath(name).resolve(String.format(CHUNK_NAME_FORMAT, position.x(), position.z()));
    }

    @Override
    public boolean arenaFileExists(String name) {
        return Files.exists(this.arenaMeta(name), new LinkOption[0]);
    }

    @Override
    public boolean createEmptyArenaFiles(String name) {
        try {
            Path arenaMeta = this.arenaMeta(name);
            Files.createDirectories(arenaMeta.getParent(), new FileAttribute[0]);
            Files.createFile(arenaMeta, new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean deleteArena(String name) {
        boolean bl;
        block8: {
            Stream<Path> stream = Files.walk(this.arenaPath(name), 1, new FileVisitOption[0]);
            try {
                stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                bl = true;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    private boolean isMeta(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().equals(ARENA_META);
    }

    @Override
    public CompletableFuture<Iterable<Arena>> loadAllArenas() {
        return this.executor.submit(() -> {
            List<Arena> arenas;
            try (Stream<Path> stream = Files.walk(this.container, 2, new FileVisitOption[0]);){
                arenas = stream.filter(this::isMeta).map(this::loadArena).filter(Objects::nonNull).toList();
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            return arenas;
        }).exceptionally(t -> {
            this.logger.error(t.getMessage(), t);
            return List.of();
        });
    }

    @Override
    public CompletableFuture<Arena> saveArena(Arena arena) {
        return this.executor.submit(() -> {
            Arena arena2;
            block8: {
                ConfigurationReference<BasicConfigurationNode> ref = this.load(this.arenaMeta(arena.name()));
                try {
                    ref.set(NodePath.path(), (Object)arena);
                    ref.save();
                    arena2 = arena;
                    if (ref == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (ref != null) {
                            try {
                                ref.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                }
                ref.close();
            }
            return arena2;
        }).exceptionally(e -> {
            this.logger.error(e.getMessage(), e);
            return null;
        });
    }

    /*
     * Exception decompiling
     */
    private Snapshot loadData(String name, ChunkRegion.Validated chunkRegion) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public CompletableFuture<Collection<Snapshot>> loadDataAsync(String name, Collection<ChunkRegion.Validated> chunkRegions) {
        return this.executor.submit(() -> {
            ArrayList<Snapshot> result = new ArrayList<Snapshot>();
            try {
                for (ChunkRegion.Validated chunkRegion : chunkRegions) {
                    result.add(this.loadData(name, chunkRegion));
                }
                return result;
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }).exceptionally(e -> {
            this.logger.error(e.getMessage(), e);
            return List.of();
        });
    }

    private long saveData(String name, Snapshot snapshot) throws IOException {
        Checksum checksum = ALGORITHM.get();
        try (OutputStream fos = Files.newOutputStream(this.chunkPath(name, snapshot), new OpenOption[0]);
             CheckedOutputStream cos = new CheckedOutputStream(fos, checksum);
             BufferedOutputStream bos = new BufferedOutputStream(cos);
             GZIPOutputStream gos = new GZIPOutputStream(bos);
             DataOutputStream dos = new DataOutputStream(gos);
             SchemWriter writer = new SchemWriter(dos);){
            writer.write(snapshot);
        }
        return checksum.getValue();
    }

    @Override
    public CompletableFuture<Collection<ChunkRegion.Validated>> saveDataAsync(String name, Iterable<Snapshot> data) {
        return this.executor.submit(() -> {
            try {
                ArrayList<ChunkRegion.Validated> result = new ArrayList<ChunkRegion.Validated>();
                for (Snapshot cd : data) {
                    result.add(ChunkRegion.create(cd.chunk().region(), this.saveData(name, cd)));
                }
                return result;
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }).exceptionally(e -> {
            this.logger.error(e.getMessage(), e);
            return List.of();
        });
    }

    private @Nullable Arena loadArena(Path path) {
        Arena arena = null;
        try (ConfigurationReference<BasicConfigurationNode> ref = this.load(path);){
            arena = Objects.requireNonNull((Arena)((BasicConfigurationNode)ref.node()).get(Arena.class));
            for (ChunkRegion.Validated chunk : arena.chunks()) {
                Path chunkPath = this.chunkPath(arena.name(), chunk);
                this.validateChecksum(chunkPath, chunk.checksum(), this.calculateChecksum(chunkPath));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return arena;
    }

    private void validateChecksum(Path path, long expected, long provided) throws ChecksumMismatchException {
        if (expected != provided) {
            throw new ChecksumMismatchException(path.toString(), expected, provided);
        }
    }

    private long calculateChecksum(Path filePath) throws IOException {
        Checksum checksum = ALGORITHM.get();
        try (InputStream fis = Files.newInputStream(filePath, new OpenOption[0]);){
            long l;
            try (CheckedInputStream cis = new CheckedInputStream(fis, checksum);){
                byte[] buffer = new byte[8192];
                while (cis.read(buffer) >= 0) {
                }
                l = checksum.getValue();
            }
            return l;
        }
    }

    private ConfigurationReference<BasicConfigurationNode> load(Path path) throws ConfigurateException {
        return ((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().defaultOptions(o -> o.serializers(b -> b.registerAll(Serializers.ALL)))).path(path)).build().loadToReference();
    }
}

