/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.storage;

import java.io.IOException;
import java.util.Locale;

public class ChecksumMismatchException
extends IOException {
    private static final String MSG = "Checksum mismatch for file: %s, expected '%s' but found '%s'. File data might be corrupted.";

    public ChecksumMismatchException(String file, long expected, long provided) {
        super(ChecksumMismatchException.formatMsg(file, expected, provided));
    }

    private static String formatMsg(String file, long expected, long provided) {
        return String.format(MSG, file, ChecksumMismatchException.toHex(expected), ChecksumMismatchException.toHex(provided));
    }

    private static String toHex(long checksum) {
        return Long.toHexString(checksum).toUpperCase(Locale.ROOT);
    }
}

