/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.service;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.moros.gaia.api.arena.region.Region;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.api.service.SelectionService;
import me.moros.math.Vector3i;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.key.Key;
import org.jspecify.annotations.Nullable;

public abstract class AbstractSelectionService
implements SelectionService {
    private final Map<UUID, Selection> cache = new ConcurrentHashMap<UUID, Selection>();

    protected AbstractSelectionService() {
    }

    @Override
    public void resetSelection(GaiaUser user) {
        user.get(Identity.UUID).ifPresent(this::invalidate);
    }

    protected void invalidate(UUID uuid) {
        this.cache.remove(uuid);
    }

    protected void registerClick(UUID uuid, Key level, Vector3i point) {
        this.updateAndGet(uuid, level).registerPos(point, true);
    }

    protected void registerInteraction(UUID uuid, Key level, Vector3i point) {
        this.updateAndGet(uuid, level).registerPos(point, false);
    }

    private Selection updateAndGet(UUID uuid, Key level) {
        return this.cache.compute(uuid, (key, oldSel) -> {
            if (oldSel == null || !oldSel.level.equals((Object)level)) {
                return new Selection(level);
            }
            return oldSel;
        });
    }

    @Override
    public Optional<Region> selection(GaiaUser user) {
        Key levelKey = user.level().orElse(null);
        if (user.isPlayer() && levelKey != null) {
            return user.get(Identity.UUID).map(this.cache::get).filter(s -> s.level().equals((Object)levelKey)).flatMap(Selection::asRegion);
        }
        return Optional.empty();
    }

    private static final class Selection {
        private final Key level;
        private Vector3i pos1;
        private Vector3i pos2;

        private Selection(Key level) {
            this.level = level;
        }

        private Key level() {
            return this.level;
        }

        private void registerPos(@Nullable Vector3i pos, boolean primary) {
            if (primary) {
                this.pos1 = pos;
            } else {
                this.pos2 = pos;
            }
        }

        private Optional<Region> asRegion() {
            if (this.pos1 == null || this.pos2 == null) {
                return Optional.empty();
            }
            return Optional.of(Region.of(this.pos1, this.pos2));
        }
    }
}

