/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.event;

import gaia.libraries.eventbus.Cancellable;
import gaia.libraries.eventbus.EventConfig;
import gaia.libraries.eventbus.bus.SimpleEventBus;
import gaia.libraries.eventbus.registry.EventRegistry;
import gaia.libraries.eventbus.registry.SimpleEventRegistry;
import java.util.function.Consumer;
import me.moros.gaia.api.arena.Arena;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.event.ArenaAnalyzeEvent;
import me.moros.gaia.api.event.ArenaRevertEvent;
import me.moros.gaia.api.event.ChunkAnalyzeEvent;
import me.moros.gaia.api.event.ChunkRevertEvent;
import me.moros.gaia.api.event.EventBus;
import me.moros.gaia.api.event.GaiaEvent;
import me.moros.gaia.common.event.ArenaAnalyzeEventImpl;
import me.moros.gaia.common.event.ArenaRevertEventImpl;
import me.moros.gaia.common.event.ChunkAnalyzeEventImpl;
import me.moros.gaia.common.event.ChunkRevertEventImpl;
import me.moros.gaia.common.event.EventExceptionHandlerImpl;
import me.moros.gaia.common.event.EventSubscriberImpl;
import net.kyori.adventure.key.Key;
import org.slf4j.Logger;

public class EventBusImpl
implements EventBus {
    private final EventRegistry<GaiaEvent> eventRegistry = new SimpleEventRegistry<GaiaEvent>(GaiaEvent.class);
    private final gaia.libraries.eventbus.bus.EventBus<GaiaEvent> eventBus;
    private boolean closed = false;

    public EventBusImpl(Logger logger) {
        this.eventBus = new SimpleEventBus<GaiaEvent>(this.eventRegistry, new EventExceptionHandlerImpl(logger));
    }

    @Override
    public void shutdown() {
        this.eventRegistry.unsubscribeIf(x -> true);
        this.closed = true;
    }

    @Override
    public <T extends GaiaEvent> void subscribe(Class<T> event, Consumer<? super T> subscriber, int priority) {
        if (!this.closed) {
            EventConfig eventConfig = EventConfig.of(priority, false, false);
            this.eventRegistry.subscribe(event, eventConfig, new EventSubscriberImpl<T>(subscriber));
        }
    }

    @Override
    public <T extends GaiaEvent> boolean post(T event) {
        Cancellable c;
        if (this.closed) {
            throw new IllegalStateException("Eventbus has been terminated, cannot post new events!");
        }
        this.eventBus.post(event);
        return !(event instanceof Cancellable) || !(c = (Cancellable)((Object)event)).cancelled();
    }

    private <T extends GaiaEvent> T postAndReturn(T event) {
        this.post(event);
        return event;
    }

    @Override
    public ArenaAnalyzeEvent postArenaAnalyzeEvent(Arena arena, long time) {
        return this.postAndReturn(new ArenaAnalyzeEventImpl(arena, time));
    }

    @Override
    public ArenaRevertEvent postArenaRevertEvent(Arena arena, long time, boolean completed) {
        return this.postAndReturn(new ArenaRevertEventImpl(arena, time, completed));
    }

    @Override
    public ChunkAnalyzeEvent postChunkAnalyzeEvent(ChunkRegion chunk, Key level, long time) {
        return this.postAndReturn(new ChunkAnalyzeEventImpl(chunk, level, time));
    }

    @Override
    public ChunkRevertEvent postChunkRevertEvent(ChunkRegion chunk, Key level, long time) {
        return this.postAndReturn(new ChunkRevertEventImpl(chunk, level, time));
    }
}

