/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import me.moros.gaia.common.config.Config;
import org.slf4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.reference.ConfigurationReference;
import org.spongepowered.configurate.reference.ValueReference;
import org.spongepowered.configurate.reference.WatchServiceListener;

public final class ConfigManager {
    private static ConfigManager INSTANCE;
    private final Config defaultConfig = new Config();
    private final ConfigurationReference<CommentedConfigurationNode> reference;
    private final ValueReference<Config, CommentedConfigurationNode> configReference;

    public ConfigManager(Logger logger, Path directory, WatchServiceListener listener) throws IOException {
        Path path = directory.resolve("gaia.conf");
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        this.reference = listener.listenToConfiguration(f -> ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(f)).build(), path);
        this.reference.errors().subscribe(e -> logger.warn(((Throwable)e.getValue()).getMessage(), (Throwable)e.getValue()));
        this.configReference = this.reference.referenceTo(Config.class, NodePath.path(), (Object)this.defaultConfig);
        this.reference.save();
        if (INSTANCE == null) {
            INSTANCE = this;
        }
    }

    public void subscribe(Consumer<Config> subscriber) {
        this.reference.updates().subscribe(n -> subscriber.accept(this.config()));
    }

    public void close() {
        this.reference.close();
    }

    public Config config() {
        Config config = (Config)this.configReference.get();
        return config == null ? this.defaultConfig : config;
    }

    public static ConfigManager instance() {
        return INSTANCE;
    }
}

