/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.config;

import me.moros.gaia.api.util.LightFixer;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public record Config(@Comment(value="The maximum amount of time in milliseconds for snapshot analysis") long timeout, @Comment(value="The cooldown in milliseconds before an arena can be reverted again") long cooldown, @Comment(value="The maximum amount of chunks that will be restored every tick") int concurrentChunks, @Comment(value="The maximum amount of chunk sections that will be restored every tick per chunk") int sectionsPerTick, @Comment(value="Light fixer can optionally queue light recalculations for reverted chunks/arenas in a 2nd pass. Available options: DISABLED, POST-CHUNK, POST-ARENA") LightFixer lightFixer) {
    public Config(long timeout, long cooldown, int concurrentChunks, int sectionsPerTick, @Nullable LightFixer lightFixer) {
        this.timeout = timeout > 0L ? timeout : 30000L;
        this.cooldown = cooldown > 0L ? cooldown : 5000L;
        this.concurrentChunks = concurrentChunks > 0 ? concurrentChunks : 16;
        this.sectionsPerTick = sectionsPerTick > 0 ? sectionsPerTick : 24;
        this.lightFixer = lightFixer == null ? LightFixer.POST_ARENA : lightFixer;
    }

    Config() {
        this(30000L, 5000L, 16, 24, LightFixer.POST_ARENA);
    }
}

