/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.command.commands;

import gaia.libraries.cloud.Command;
import gaia.libraries.cloud.component.DefaultValue;
import gaia.libraries.cloud.minecraft.extras.RichDescription;
import gaia.libraries.cloud.parser.standard.IntegerParser;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.gaia.api.arena.Arena;
import me.moros.gaia.api.arena.Point;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.common.command.CommandPermissions;
import me.moros.gaia.common.command.Commander;
import me.moros.gaia.common.command.GaiaCommand;
import me.moros.gaia.common.command.parser.ArenaParser;
import me.moros.gaia.common.locale.Message;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.ComponentLike;

public record PointCommand(Commander commander) implements GaiaCommand
{
    @Override
    public void register() {
        Command.Builder<GaiaUser> builder = this.commander().rootBuilder();
        this.commander().register(builder.literal("addpoint", new String[0]).commandDescription(RichDescription.of((ComponentLike)Message.POINT_ADD_CMD_DESC.build())).permission(CommandPermissions.POINT).handler(c -> this.onPointAdd((GaiaUser)c.sender())));
        this.commander().register(builder.literal("clearpoints", new String[0]).optional("arena", ArenaParser.parser(), DefaultValue.parsed("cur")).commandDescription(RichDescription.of((ComponentLike)Message.POINT_CLEAR_CMD_DESC.build())).permission(CommandPermissions.POINT).handler(c -> this.onPointClear((GaiaUser)c.sender(), (Arena)c.get("arena"))));
        this.commander().register(builder.literal("teleport", new String[0]).optional("arena", ArenaParser.parser(), DefaultValue.parsed("cur")).optional("id", IntegerParser.integerParser(1), DefaultValue.constant(0)).commandDescription(RichDescription.of((ComponentLike)Message.POINT_TELEPORT_CMD_DESC.build())).permission(CommandPermissions.TELEPORT).handler(c -> this.onPointTeleport((GaiaUser)c.sender(), (Arena)c.get("arena"), (Integer)c.get("id"))));
    }

    private void onPointAdd(GaiaUser user) {
        Arena arena = user.level().flatMap(l -> user.parent().arenaService().arena((Key)l, user.position())).orElse(null);
        if (arena == null) {
            Message.ADD_POINT_FAIL_AREA.send((Audience)user);
            return;
        }
        Point point = user.createPoint().orElse(null);
        if (point != null) {
            arena.addPoint(point);
            user.parent().storage().saveArena(arena).thenRun(() -> Message.ADD_POINT_SUCCESS.send((Audience)user));
        } else {
            Message.ADD_POINT_FAIL.send((Audience)user);
        }
    }

    private void onPointClear(GaiaUser user, Arena arena) {
        arena.clearPoints();
        user.parent().storage().saveArena(arena).thenRun(() -> Message.CLEAR_POINTS.send((Audience)user, arena.displayName()));
    }

    private void onPointTeleport(GaiaUser user, Arena arena, int id) {
        List<Point> points = arena.points();
        if (points.isEmpty()) {
            Message.NO_POINTS.send((Audience)user, arena.displayName());
            return;
        }
        if (id > points.size()) {
            Message.INVALID_POINT.send((Audience)user);
            return;
        }
        Point pointToTeleport = points.get(id == 0 ? ThreadLocalRandom.current().nextInt(points.size()) : id - 1);
        user.teleport(arena.level(), pointToTeleport);
    }
}

