/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.command.commands;

import gaia.libraries.cloud.Command;
import gaia.libraries.cloud.CommandManager;
import gaia.libraries.cloud.minecraft.extras.ImmutableMinecraftHelp;
import gaia.libraries.cloud.minecraft.extras.MinecraftHelp;
import gaia.libraries.cloud.minecraft.extras.RichDescription;
import gaia.libraries.cloud.parser.standard.StringParser;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.common.command.CommandPermissions;
import me.moros.gaia.common.command.Commander;
import me.moros.gaia.common.command.GaiaCommand;
import me.moros.gaia.common.locale.Message;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public record HelpCommand(Commander commander, MinecraftHelp<GaiaUser> help) implements GaiaCommand
{
    public HelpCommand(Commander commander) {
        this(commander, HelpCommand.createHelp(commander.manager()));
    }

    @Override
    public void register() {
        Command.Builder<GaiaUser> builder = this.commander().rootBuilder();
        this.commander().register(builder.commandDescription(RichDescription.of((ComponentLike)Message.BASE_CMD_DESC.build())).handler(c -> this.help().queryCommands("", (GaiaUser)c.sender())));
        this.commander().register(builder.literal("help", new String[0]).optional("query", StringParser.greedyStringParser()).commandDescription(RichDescription.of((ComponentLike)Message.HELP_CMD_DESC.build())).permission(CommandPermissions.HELP).handler(c -> this.help.queryCommands(c.getOrDefault("query", ""), (GaiaUser)c.sender())));
    }

    private static <C extends Audience> MinecraftHelp<C> createHelp(CommandManager<C> manager) {
        return ImmutableMinecraftHelp.copyOf(MinecraftHelp.createNative("/gaia help", manager)).withMaxResultsPerPage(9).withColors(MinecraftHelp.helpColors((TextColor)NamedTextColor.DARK_GRAY, (TextColor)NamedTextColor.DARK_AQUA, (TextColor)NamedTextColor.GRAY, (TextColor)NamedTextColor.AQUA, (TextColor)NamedTextColor.GRAY));
    }
}

