/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.api.util;

import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public final class TextUtil {
    private static final Pattern NON_ALPHANUMERICAL = Pattern.compile("[^A-Za-z0-9]");
    private static final Pattern VALID = Pattern.compile("[a-z0-9]{3,64}");

    private TextUtil() {
    }

    public static String sanitizeInput(@Nullable String input) {
        if (input == null) {
            return "";
        }
        String output = NON_ALPHANUMERICAL.matcher(input).replaceAll("").toLowerCase();
        return output.length() > 32 ? output.substring(0, 32) : output;
    }

    public static boolean validateInput(String input) {
        return VALID.matcher(input).matches();
    }

    public static String generateLine(int count) {
        char[] line = new char[count];
        Arrays.fill(line, '-');
        return new String(line);
    }

    public static String description(int size) {
        int chunkArea = 256;
        if (size <= 65536) {
            return "Tiny";
        }
        if (size <= 819200) {
            return "Small";
        }
        if (size <= 0x4B0000) {
            return "Medium";
        }
        if (size <= 0x1000000) {
            return "Large";
        }
        return "Huge";
    }

    public static String formatDuration(long deltaTime) {
        int minutes;
        int hours;
        Duration duration = Duration.ofMillis(deltaTime);
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        long days = duration.toDaysPart();
        if (days > 0L) {
            parts.add((CallSite)((Object)(days + "d")));
        }
        if ((hours = duration.toHoursPart()) > 0 || !parts.isEmpty()) {
            parts.add((CallSite)((Object)(hours + "h")));
        }
        if ((minutes = duration.toMinutesPart()) > 0 || !parts.isEmpty()) {
            parts.add((CallSite)((Object)(minutes + "m")));
        }
        int seconds = Math.max(1, duration.toSecondsPart());
        parts.add((CallSite)((Object)(seconds + "s")));
        return String.join((CharSequence)" ", parts);
    }
}

