/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.api.util;

import java.text.NumberFormat;
import me.moros.gaia.api.arena.Arena;
import me.moros.gaia.api.arena.Point;
import me.moros.gaia.api.arena.region.Region;
import me.moros.gaia.api.util.TextUtil;
import me.moros.math.Position;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public final class ComponentUtil {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private static final String DELIMITER = ", ";

    private ComponentUtil() {
    }

    public static Component pointInfo(Point point) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append(Component.text((String)"Position: ").append(ComponentUtil.clickableVector(point).color((TextColor)NamedTextColor.GREEN)))).appendNewline()).append(Component.text((String)"Yaw/Pitch: ").append((Component)Component.text((String)ComponentUtil.formatDir(point.yaw(), point.pitch()), (TextColor)NamedTextColor.GREEN)))).appendNewline()).appendNewline()).append((Component)Component.text((String)"Click to teleport to point.", (TextColor)NamedTextColor.GRAY))).build();
    }

    public static Component generatePointInfo(Arena arena, Point point, int index) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((int)index, (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)ComponentUtil.pointInfo(point)))).clickEvent(ClickEvent.runCommand((String)("/gaia teleport " + arena.name() + " " + index)))).build();
    }

    public static Component arenaInfoAsHover(Arena arena) {
        Component infoDetails = arena.info().appendNewline().appendNewline().append((Component)Component.text((String)"Click to copy center coordinates to clipboard.", (TextColor)NamedTextColor.GRAY));
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"> ", (TextColor)NamedTextColor.DARK_GRAY))).append(arena.displayName())).hoverEvent((HoverEventSource)HoverEvent.showText((Component)infoDetails))).clickEvent(ClickEvent.copyToClipboard((String)ComponentUtil.formatVec(arena.region().center(), " ")))).build();
    }

    public static Component generateInfo(Arena arena) {
        int volume = arena.region().volume();
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"Name: "))).append((Component)Component.text((String)arena.name(), (TextColor)NamedTextColor.GREEN))).appendNewline()).append((Component)Component.text((String)"World: "))).append((Component)Component.text((String)arena.level().value(), (TextColor)NamedTextColor.GREEN))).appendNewline()).append((Component)Component.text((String)"Region: "))).append(ComponentUtil.region(arena.region()))).appendNewline()).append((Component)Component.text((String)"Dimensions: "))).append((Component)Component.text((String)ComponentUtil.formatVec(arena.region().size(), " x "), (TextColor)NamedTextColor.GREEN))).appendNewline()).append((Component)Component.text((String)"Volume: "))).append((Component)Component.text((String)(String.format("%,d", volume) + " (" + TextUtil.description(volume) + ")"), (TextColor)NamedTextColor.GREEN))).appendNewline()).append((Component)Component.text((String)"Center: "))).append(ComponentUtil.clickableVector(arena.region().center()).color((TextColor)NamedTextColor.GREEN))).build();
    }

    private static Component region(Region region) {
        Component min = ComponentUtil.clickableVector(region.min());
        Component max = ComponentUtil.clickableVector(region.max());
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GREEN)).append(min)).append((Component)Component.text((String)" to "))).append(max)).build();
    }

    private static Component clickableVector(Position pos) {
        TextComponent hover = Component.text((String)"Click to copy coordinates to clipboard.", (TextColor)NamedTextColor.GRAY);
        return ((TextComponent)Component.text((String)ComponentUtil.formatVecAsArray(pos)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover))).clickEvent(ClickEvent.copyToClipboard((String)ComponentUtil.formatVec(pos, " ")));
    }

    private static String formatVecAsArray(Position pos) {
        return "[" + ComponentUtil.formatVec(pos, DELIMITER) + "]";
    }

    private static String formatVec(Position vector, String delimiter) {
        return NUMBER_FORMAT.format(vector.x()) + delimiter + NUMBER_FORMAT.format(vector.y()) + delimiter + NUMBER_FORMAT.format(vector.z());
    }

    private static String formatDir(float yaw, float pitch) {
        return NUMBER_FORMAT.format(yaw) + DELIMITER + NUMBER_FORMAT.format(pitch);
    }

    static {
        NUMBER_FORMAT.setMinimumFractionDigits(0);
        NUMBER_FORMAT.setMaximumFractionDigits(2);
    }
}

