/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.api.arena.region;

import me.moros.gaia.api.arena.region.RegionImpl;
import me.moros.gaia.api.util.ChunkUtil;
import me.moros.math.Position;
import me.moros.math.Vector3i;

public sealed interface Region
permits RegionImpl {
    public Vector3i min();

    public Vector3i max();

    default public Vector3i size() {
        return ((Vector3i)this.max().subtract(this.min())).add(1.0, 1.0, 1.0);
    }

    default public int volume() {
        Vector3i size = this.size();
        return size.blockX() * size.blockY() * size.blockZ();
    }

    default public Vector3i center() {
        return (Vector3i)((Vector3i)((Vector3i)this.min().add(this.max())).add(Vector3i.ONE)).multiply(0.5);
    }

    default public boolean contains(int x, int y, int z) {
        return x >= this.min().blockX() && x <= this.max().blockX() && y >= this.min().blockY() && y <= this.max().blockY() && z >= this.min().blockZ() && z <= this.max().blockZ();
    }

    default public boolean contains(Position vector) {
        double x = vector.x();
        double y = vector.y();
        double z = vector.z();
        return x >= this.min().x() && x <= this.max().x() && y >= this.min().y() && y <= this.max().y() && z >= this.min().z() && z <= this.max().z();
    }

    default public boolean intersects(Region region) {
        return this.min().x() <= region.max().x() && this.max().x() >= region.min().x() && this.min().y() <= region.max().y() && this.max().y() >= region.min().y() && this.min().z() <= region.max().z() && this.max().z() >= region.min().z();
    }

    public static Region of(Vector3i min, Vector3i max) {
        ChunkUtil.ensureValidPosition(min);
        ChunkUtil.ensureValidPosition(max);
        return new RegionImpl(min.min(max), min.max(max));
    }
}

