/*
 * Decompiled with CFR 0.152.
 */
package gaia.libraries.linbus.tree;

import gaia.libraries.linbus.common.LinTagId;
import gaia.libraries.linbus.stream.LinBinaryIO;
import gaia.libraries.linbus.stream.LinStream;
import gaia.libraries.linbus.stream.LinStreamable;
import gaia.libraries.linbus.stream.internal.SurroundingLinStream;
import gaia.libraries.linbus.stream.token.LinToken;
import gaia.libraries.linbus.tree.LinCompoundTag;
import gaia.libraries.linbus.tree.ToLinTag;
import gaia.libraries.linbus.tree.impl.LinTagReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;

public record LinRootEntry(String name, LinCompoundTag value) implements ToLinTag<LinCompoundTag>,
LinStreamable
{
    public LinRootEntry {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
    }

    public static LinRootEntry readFrom(LinStream tokens) throws IOException {
        return LinTagReader.readRoot(tokens);
    }

    public byte[] writeToArray() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(output);){
            LinBinaryIO.write(dataOutputStream, this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return output.toByteArray();
    }

    @Override
    public LinCompoundTag toLinTag() {
        return LinCompoundTag.of(Map.of(this.name, this.value));
    }

    @Override
    public LinStream linStream() {
        return new SurroundingLinStream(new LinToken.Name(this.name, LinTagId.COMPOUND), this.value.linStream(), null);
    }
}

