/*
 * Decompiled with CFR 0.152.
 */
package me.moros.tasker.executor;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.moros.tasker.Task;
import me.moros.tasker.TimerWheel;
import me.moros.tasker.executor.SyncExecutor;
import org.jspecify.annotations.Nullable;

public abstract class AbstractSyncExecutor
implements SyncExecutor {
    protected final TimerWheel wheel;

    protected AbstractSyncExecutor(TimerWheel wheel) {
        this.wheel = Objects.requireNonNull(wheel);
    }

    protected AbstractSyncExecutor() {
        this.wheel = TimerWheel.hierarchical();
    }

    @Override
    public <V> CompletableFuture<@Nullable V> submit(Supplier<@Nullable V> task, int ticks) {
        Objects.requireNonNull(task);
        this.checkValid();
        CompletableFuture future = new CompletableFuture();
        this.wheel.schedule(AbstractSyncExecutor.bind(task, future), ticks, 0);
        return future;
    }

    @Override
    public Task repeat(Consumer<? super Task> consumer, int ticks, int periodTicks) {
        Objects.requireNonNull(consumer);
        this.checkValid();
        return this.wheel.schedule(consumer, ticks, periodTicks);
    }

    @Override
    public final void clear() {
        this.wheel.shutdown(false);
    }

    @Override
    public void shutdown() {
        this.clear();
    }

    protected void checkValid() {
        if (!this.isValid()) {
            throw new RejectedExecutionException("Cannot execute now!");
        }
    }

    private static <V> Consumer<? super Task> bind(Supplier<@Nullable V> task, CompletableFuture<@Nullable V> future) {
        return t -> {
            try {
                future.complete(task.get());
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        };
    }
}

