/*
 * Decompiled with CFR 0.152.
 */
package me.moros.math;

import me.moros.math.Rotation;
import me.moros.math.Vector3d;

record DoubleQuaternion(double q0, double q1, double q2, double q3) implements Rotation
{
    @Override
    public double[][] getMatrix() {
        double q0q0 = this.q0 * this.q0;
        double q0q1 = this.q0 * this.q1;
        double q0q2 = this.q0 * this.q2;
        double q0q3 = this.q0 * this.q3;
        double q1q1 = this.q1 * this.q1;
        double q1q2 = this.q1 * this.q2;
        double q1q3 = this.q1 * this.q3;
        double q2q2 = this.q2 * this.q2;
        double q2q3 = this.q2 * this.q3;
        double q3q3 = this.q3 * this.q3;
        double[][] m = new double[][]{new double[3], new double[3], new double[3]};
        m[0][0] = 2.0 * (q0q0 + q1q1) - 1.0;
        m[1][0] = 2.0 * (q1q2 - q0q3);
        m[2][0] = 2.0 * (q1q3 + q0q2);
        m[0][1] = 2.0 * (q1q2 + q0q3);
        m[1][1] = 2.0 * (q0q0 + q2q2) - 1.0;
        m[2][1] = 2.0 * (q2q3 - q0q1);
        m[0][2] = 2.0 * (q1q3 - q0q2);
        m[1][2] = 2.0 * (q2q3 + q0q1);
        m[2][2] = 2.0 * (q0q0 + q3q3) - 1.0;
        return m;
    }

    @Override
    public Vector3d applyTo(double x, double y, double z) {
        return this.apply(x, y, z, this.q0);
    }

    @Override
    public Vector3d applyInverseTo(double x, double y, double z) {
        return this.apply(x, y, z, -this.q0);
    }

    @Override
    public Rotation applyTo(Rotation r) {
        return this.apply(r, r.q0(), r.q1(), r.q2(), r.q3());
    }

    @Override
    public Rotation applyInverseTo(Rotation r) {
        return this.apply(r, -r.q0(), -r.q1(), -r.q2(), -r.q3());
    }

    private Vector3d apply(double x, double y, double z, double m0) {
        double s = this.q1 * x + this.q2 * y + this.q3 * z;
        return Vector3d.of(2.0 * (m0 * (x * m0 - (this.q2 * z - this.q3 * y)) + s * this.q1) - x, 2.0 * (m0 * (y * m0 - (this.q3 * x - this.q1 * z)) + s * this.q2) - y, 2.0 * (m0 * (z * m0 - (this.q1 * y - this.q2 * x)) + s * this.q3) - z);
    }

    private Rotation apply(Rotation r, double m0, double m1, double m2, double m3) {
        return new DoubleQuaternion(m0 * this.q0 - (r.q1() * this.q1 + r.q2() * this.q2 + r.q3() * this.q3), m1 * this.q0 + r.q0() * this.q1 + (r.q2() * this.q3 - r.q3() * this.q2), m2 * this.q0 + r.q0() * this.q2 + (r.q3() * this.q1 - r.q1() * this.q3), m3 * this.q0 + r.q0() * this.q3 + (r.q1() * this.q2 - r.q2() * this.q1));
    }
}

