/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.platform.particle;

import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.particle.ParticleContext;
import me.moros.bending.api.platform.particle.ParticleDustData;
import me.moros.bending.paper.platform.PlatformAdapter;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.jspecify.annotations.Nullable;

public final class ParticleMapper {
    public static <T> @Nullable Object mapParticleData(ParticleContext<T> context) {
        Particle p = context.particle();
        T data = context.data();
        if ((p == Particle.BLOCK || p == Particle.FALLING_DUST || p == Particle.BLOCK_MARKER) && data instanceof BlockState) {
            BlockState state = (BlockState)data;
            return PlatformAdapter.toBukkitData(state);
        }
        if (p == Particle.ITEM && data instanceof Item) {
            Item item = (Item)data;
            return PlatformAdapter.toBukkitItem(item);
        }
        if (p == Particle.DUST && data instanceof ParticleDustData) {
            ParticleDustData dust = (ParticleDustData)data;
            return new Particle.DustOptions(Color.fromRGB((int)dust.red(), (int)dust.green(), (int)dust.blue()), dust.size());
        }
        if (p == Particle.DUST_COLOR_TRANSITION && data instanceof ParticleDustData.Transitive) {
            ParticleDustData.Transitive dust = (ParticleDustData.Transitive)data;
            Color from = Color.fromRGB((int)dust.red(), (int)dust.green(), (int)dust.blue());
            Color to = Color.fromRGB((int)dust.toRed(), (int)dust.toGreen(), (int)dust.toBlue());
            return new Particle.DustTransition(from, to, dust.size());
        }
        return null;
    }
}

