/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.platform.item;

import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.moros.bending.api.locale.Translation;
import me.moros.bending.api.platform.item.ItemBuilder;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.metadata.Metadata;
import me.moros.bending.paper.platform.PlatformAdapter;
import me.moros.bending.paper.platform.item.BukkitItem;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.GlobalTranslator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jspecify.annotations.Nullable;

public class BukkitItemBuilder
implements ItemBuilder {
    private final ItemStack stack;
    private final Map<DataKey<?>, Object> meta = new HashMap();

    public BukkitItemBuilder(ItemStack stack) {
        this.stack = stack.clone();
    }

    private @Nullable Component tryRender(@Nullable Component input) {
        return input == null ? null : GlobalTranslator.render((Component)input, (Locale)Translation.DEFAULT_LOCALE);
    }

    @Override
    public ItemBuilder name(Component name) {
        this.stack.setData(DataComponentTypes.CUSTOM_NAME, (Object)this.tryRender(name));
        return this;
    }

    @Override
    public ItemBuilder lore(List<Component> lore) {
        this.stack.setData(DataComponentTypes.LORE, (Object)ItemLore.lore(lore.stream().map(this::tryRender).toList()));
        return this;
    }

    @Override
    public <T> ItemBuilder meta(DataKey<T> key, T value) {
        if (Metadata.isPersistent(key)) {
            this.meta.put(key, value);
        }
        return this;
    }

    @Override
    public ItemBuilder unbreakable(boolean unbreakable) {
        if (unbreakable) {
            this.stack.setData(DataComponentTypes.UNBREAKABLE);
        } else {
            this.stack.unsetData((DataComponentType)DataComponentTypes.UNBREAKABLE);
        }
        return this;
    }

    @Override
    public ItemSnapshot build(int amount) {
        if (amount <= 0) {
            throw new IllegalStateException("Non positive amount: " + amount);
        }
        this.stack.setAmount(amount);
        if (!this.meta.isEmpty()) {
            this.stack.editMeta(m -> {
                PersistentDataContainer data = m.getPersistentDataContainer();
                for (Map.Entry<DataKey<?>, Object> entry : this.meta.entrySet()) {
                    BukkitItemBuilder.addMeta(data, entry.getKey(), entry.getValue());
                }
            });
        }
        return new BukkitItem(this.stack);
    }

    private static <T> void addMeta(PersistentDataContainer store, DataKey<T> key, Object value) {
        PersistentDataType<?, T> type = PlatformAdapter.dataType(key);
        if (type != null) {
            store.set(PlatformAdapter.nsk(key), type, value);
        }
    }
}

