/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.platform.entity;

import java.util.Collection;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.DamageSource;
import me.moros.bending.api.event.BendingDamageEvent;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.item.Inventory;
import me.moros.bending.api.platform.potion.Potion;
import me.moros.bending.api.user.User;
import me.moros.bending.paper.platform.DamageUtil;
import me.moros.bending.paper.platform.PlatformAdapter;
import me.moros.bending.paper.platform.entity.BukkitEntity;
import me.moros.bending.paper.platform.item.BukkitInventory;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jspecify.annotations.Nullable;

public class BukkitLivingEntity
extends BukkitEntity
implements me.moros.bending.api.platform.entity.LivingEntity {
    public BukkitLivingEntity(LivingEntity handle) {
        super((Entity)handle);
    }

    public LivingEntity handle() {
        return (LivingEntity)super.handle();
    }

    @Override
    public double eyeHeight() {
        return this.handle().getEyeHeight();
    }

    @Override
    public @Nullable Inventory inventory() {
        EntityEquipment equipment = this.handle().getEquipment();
        return equipment == null ? null : new BukkitInventory(equipment);
    }

    @Override
    public boolean addPotion(Potion potion) {
        return this.handle().addPotionEffect(PlatformAdapter.toBukkitPotion(potion));
    }

    @Override
    public boolean hasPotion(me.moros.bending.api.platform.potion.PotionEffect effect) {
        return this.handle().hasPotionEffect(PlatformAdapter.toBukkitPotion(effect));
    }

    @Override
    public @Nullable Potion potion(me.moros.bending.api.platform.potion.PotionEffect effect) {
        PotionEffect potion = this.handle().getPotionEffect(PlatformAdapter.toBukkitPotion(effect));
        return potion == null ? null : PlatformAdapter.fromBukkitPotion(potion);
    }

    @Override
    public void removePotion(me.moros.bending.api.platform.potion.PotionEffect effect) {
        this.handle().removePotionEffect(PlatformAdapter.toBukkitPotion(effect));
    }

    @Override
    public Collection<Potion> activePotions() {
        return this.handle().getActivePotionEffects().stream().map(PlatformAdapter::fromBukkitPotion).toList();
    }

    @Override
    public boolean damage(double damage) {
        this.handle().damage(damage);
        return true;
    }

    @Override
    public boolean damage(double damage, me.moros.bending.api.platform.entity.Entity source) {
        this.handle().damage(damage, PlatformAdapter.toBukkitEntity(source));
        return true;
    }

    @Override
    public boolean damage(double damage, User source, AbilityDescription desc) {
        BendingDamageEvent event = source.game().eventBus().postAbilityDamageEvent(source, desc, this, damage);
        double dmg = event.damage();
        if (event.cancelled() || dmg <= 0.0) {
            return false;
        }
        if (this.type() == EntityType.PLAYER) {
            DamageUtil.cacheDamageSource(this.uuid(), DamageSource.of(source.name(), desc));
        }
        return Platform.instance().nativeAdapter().damage(event);
    }

    @Override
    public me.moros.bending.api.platform.entity.Entity shootArrow(Position origin, Vector3d direction, double power) {
        World w = this.handle().getWorld();
        Location loc = new Location(w, origin.x(), origin.y(), origin.z());
        Arrow arrow = w.spawnArrow(loc, new Vector(direction.x(), direction.y(), direction.z()), (float)power, 0.0f);
        arrow.setShooter((ProjectileSource)this.handle());
        arrow.setGravity(false);
        arrow.setInvulnerable(true);
        arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
        return PlatformAdapter.fromBukkitEntity((Entity)arrow);
    }
}

