/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.platform.block;

import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.property.Property;
import me.moros.bending.common.data.DataProvider;
import me.moros.bending.paper.platform.PlatformAdapter;
import me.moros.bending.paper.platform.block.BukkitBlockStateProperties;
import org.bukkit.block.data.BlockData;
import org.jspecify.annotations.Nullable;

public class BukkitBlockState
implements BlockState {
    private final BlockData handle;
    private final BlockType type;

    private BukkitBlockState(BlockData newData, BlockType type) {
        this.handle = newData;
        this.type = type;
    }

    public BukkitBlockState(BlockData handle) {
        this(handle.clone(), PlatformAdapter.fromBukkitBlock(handle.getMaterial()));
    }

    public BlockData handle() {
        return this.handle;
    }

    @Override
    public BlockType type() {
        return this.type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(BlockState other) {
        if (!(other instanceof BukkitBlockState)) return false;
        BukkitBlockState b = (BukkitBlockState)other;
        if (!this.handle().matches(b.handle())) return false;
        return true;
    }

    @Override
    public <V extends Comparable<V>> @Nullable V property(Property<V> property) {
        return (V)((Comparable)BukkitBlockStateProperties.PROPERTIES.getValue(property, this.handle()));
    }

    @Override
    public <V extends Comparable<V>> BlockState withProperty(Property<V> property, V value) {
        BlockData copy;
        boolean result;
        DataProvider<BlockData, V> provider;
        if (property.isValidValue(value) && (provider = BukkitBlockStateProperties.PROPERTIES.getProvider(property)) != null && provider.supports(this.handle()) && (result = provider.set(copy = this.handle().clone(), value)) && !copy.equals((Object)this.handle())) {
            return new BukkitBlockState(copy, this.type());
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BukkitBlockState) {
            BukkitBlockState other = (BukkitBlockState)obj;
            return this.handle().equals((Object)other.handle());
        }
        return false;
    }

    public int hashCode() {
        return this.handle.hashCode();
    }
}

