/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.platform;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockTag;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemTag;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.platform.potion.PotionEffectTag;
import me.moros.bending.api.registry.Tag;
import me.moros.bending.api.registry.TagBuilder;
import me.moros.bending.common.util.RegistryInitializer;
import me.moros.bending.paper.platform.PlatformAdapter;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.SoundGroup;
import org.bukkit.block.data.BlockData;
import org.bukkit.potion.PotionEffectType;

public final class BukkitRegistryInitializer
implements RegistryInitializer {
    @Override
    public void initBlockTypeRegistry(me.moros.bending.api.registry.Registry<Key, BlockType> registry, me.moros.bending.api.registry.Registry<Key, BlockProperties> propertyRegistry, me.moros.bending.api.registry.Registry<Key, BlockState> stateRegistry, me.moros.bending.api.registry.Registry<Key, Item> itemRegistry) {
        for (Material mat : Registry.MATERIAL) {
            if (!mat.isBlock()) continue;
            Key key = mat.key();
            BlockType type = registry.getOrThrow(key);
            BlockData data = mat.createBlockData();
            stateRegistry.register(PlatformAdapter.fromBukkitData(data));
            propertyRegistry.register(this.mapProperties(type, data));
            Item item = Item.registry().get(key);
            if (item == null) continue;
            itemRegistry.register(item);
        }
    }

    @Override
    public void initBlockTypeTagRegistry(me.moros.bending.api.registry.Registry<Key, BlockType> registry, Function<Key, TagBuilder<BlockType, BlockTag>> builder) {
        this.initTag(registry, builder, Bukkit.getTags((String)"blocks", Material.class), Material::isBlock);
    }

    @Override
    public void initEntityTypeRegistry(me.moros.bending.api.registry.Registry<Key, EntityType> registry) {
        this.init(registry, (Iterable)Registry.ENTITY_TYPE);
    }

    @Override
    public void initItemRegistry(me.moros.bending.api.registry.Registry<Key, Item> registry) {
        this.init(registry, (Iterable)Registry.MATERIAL);
    }

    @Override
    public void initItemTagRegistry(me.moros.bending.api.registry.Registry<Key, Item> registry, Function<Key, TagBuilder<Item, ItemTag>> builder) {
        this.initTag(registry, builder, Bukkit.getTags((String)"items", Material.class), Material::isItem);
    }

    @Override
    public void initParticleRegistry(me.moros.bending.api.registry.Registry<Key, Particle> registry) {
        this.init(registry, (Iterable)Registry.PARTICLE_TYPE);
    }

    @Override
    public void initPotionEffectRegistry(me.moros.bending.api.registry.Registry<Key, PotionEffect> registry) {
        this.init(registry, (Iterable)Registry.POTION_EFFECT_TYPE);
    }

    @Override
    public void initPotionEffectTagRegistry(me.moros.bending.api.registry.Registry<Key, PotionEffect> registry, Function<Key, TagBuilder<PotionEffect, PotionEffectTag>> builder) {
        Map<PotionEffectTag, List<PotionEffectType>> map = StreamSupport.stream(Registry.POTION_EFFECT_TYPE.spliterator(), false).collect(Collectors.groupingBy(PlatformAdapter::potionCategory));
        for (Map.Entry<PotionEffectTag, List<PotionEffectType>> entry : map.entrySet()) {
            List<PotionEffect> data = entry.getValue().stream().map(p -> (PotionEffect)registry.get(p.key())).toList();
            registry.getTagOrCreate(entry.getKey().key(), k -> ((TagBuilder)builder.apply((Key)k)).add(data).build());
        }
    }

    @Override
    public void initSoundRegistry(me.moros.bending.api.registry.Registry<Key, me.moros.bending.api.platform.sound.Sound> registry) {
        this.init(registry, (Iterable)Registry.SOUNDS);
    }

    private <T extends org.bukkit.Keyed> void init(me.moros.bending.api.registry.Registry<Key, ?> registry, Iterable<T> bukkitRegistry) {
        for (org.bukkit.Keyed keyed : bukkitRegistry) {
            registry.get(keyed.key());
        }
    }

    private <V extends Keyed, T extends Tag<V>, S extends org.bukkit.Keyed> void initTag(me.moros.bending.api.registry.Registry<Key, V> registry, Function<Key, TagBuilder<V, T>> builder, Iterable<org.bukkit.Tag<S>> tags, Predicate<S> materialPredicate) {
        for (org.bukkit.Tag<S> bukkitTag : tags) {
            List<Keyed> data = bukkitTag.getValues().stream().filter(materialPredicate).map(mat -> (Keyed)registry.get(mat.key())).toList();
            if (data.isEmpty()) continue;
            registry.getTagOrCreate(bukkitTag.key(), k -> ((TagBuilder)builder.apply((Key)k)).add(data).build());
        }
    }

    private BlockProperties mapProperties(BlockType type, BlockData data) {
        Material mat = data.getMaterial();
        return BlockProperties.builder(type, mat.translationKey()).isAir(mat.isAir()).isSolid(mat.isSolid()).isLiquid(type == BlockType.WATER || type == BlockType.LAVA || type == BlockType.BUBBLE_COLUMN).isFlammable(mat.isFlammable()).hasGravity(mat.hasGravity()).isCollidable(mat.isCollidable()).hardness(mat.getHardness()).soundGroup(this.mapSoundGroup(data.getSoundGroup())).build();
    }

    private me.moros.bending.api.platform.sound.SoundGroup mapSoundGroup(SoundGroup group) {
        return new me.moros.bending.api.platform.sound.SoundGroup(this.mapSound(group.getBreakSound()), this.mapSound(group.getStepSound()), this.mapSound(group.getPlaceSound()), this.mapSound(group.getHitSound()), this.mapSound(group.getFallSound()));
    }

    private me.moros.bending.api.platform.sound.Sound mapSound(Sound sound) {
        return me.moros.bending.api.platform.sound.Sound.registry().getOrThrow((Key)Registry.SOUNDS.getKeyOrThrow((org.bukkit.Keyed)sound));
    }
}

