/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.platform;

import java.util.Optional;
import java.util.function.Supplier;
import me.moros.bending.api.util.data.DataHolder;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.functional.Suppliers;
import org.bukkit.Bukkit;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;

public record BukkitDataHolder(Metadatable handle) implements DataHolder
{
    private static final Supplier<Plugin> plugin = Suppliers.lazy(() -> Bukkit.getPluginManager().getPlugin("bending"));

    @Override
    public <T> Optional<T> get(DataKey<T> key) {
        return this.handle().getMetadata(key.value()).stream().map(MetadataValue::value).filter(key.type()::isInstance).map(key.type()::cast).findAny();
    }

    @Override
    public <T> void add(DataKey<T> key, T value) {
        this.handle().setMetadata(key.value(), (MetadataValue)new FixedMetadataValue(plugin.get(), value));
    }

    @Override
    public <T> void remove(DataKey<T> key) {
        this.handle().removeMetadata(key.value(), plugin.get());
    }
}

